/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.core.service;

import org.restexpress.url.UrlPattern;

/**
 * Class that matches request path with operation path pattern and returns the result.
 *
 * @author deba
 * @version $Id: $Id
 */
public class OpPathMatcher {

  /**
   * Matches operation path pattern with actual request path passed.
   *
   * @param opPath Operation path pattern retrieved from operation definition.
   * @param requestPath Actual request path.
   * @return true if both paths matches, false otherwise.
   */
  public boolean matchPath(String opPath, String requestPath) {
    if (opPath != null && requestPath != null && !opPath.isEmpty() && !requestPath.isEmpty()) {
      UrlPattern urlPattern = new UrlPattern(opPath);
      return urlPattern.matches(requestPath);
    }
    return false;
  }

}
