/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.core.service;

import org.appops.core.service.meta.ServiceOpMeta;

/**
 * Stores definition of appops operation parameter.
 *
 * @author deba
 * @version $Id: $Id
 */
public class Parameter {
  private String name;
  private Long id;
  private String typeName;
  private Object value;
  private int order;
  private ServiceOpMeta parent;

  /**
   * <p>Constructor for Parameter.</p>
   */
  public Parameter() {

  }


  /**
   * <p>Constructor for Parameter.</p>
   *
   * @param order a int.
   * @param name a {@link java.lang.String} object.
   * @param value a {@link java.lang.Object} object.
   */
  public Parameter(int order, String name, Object value) {
    this(order, name);
    setValue(value);
  }

  /**
   * <p>Constructor for Parameter.</p>
   *
   * @param order a int.
   * @param name a {@link java.lang.String} object.
   */
  public Parameter(int order, String name) {
    setOrder(order);
    setName(name);
  }


  /**
   * <p>Getter for the field <code>name</code>.</p>
   *
   * @return a {@link java.lang.String} object.
   */
  public String getName() {
    return name;
  }

  /**
   * <p>Setter for the field <code>name</code>.</p>
   *
   * @param name a {@link java.lang.String} object.
   */
  public void setName(String name) {
    this.name = name;
  }

  /**
   * <p>Getter for the field <code>id</code>.</p>
   *
   * @return a {@link java.lang.Long} object.
   */
  public Long getId() {
    return id;
  }

  /**
   * <p>Setter for the field <code>id</code>.</p>
   *
   * @param id a {@link java.lang.Long} object.
   */
  public void setId(Long id) {
    this.id = id;
  }

  /**
   * <p>Getter for the field <code>value</code>.</p>
   *
   * @return a {@link java.lang.Object} object.
   */
  public Object getValue() {
    return value;
  }

  /**
   * <p>Setter for the field <code>value</code>.</p>
   *
   * @param value a {@link java.lang.Object} object.
   */
  public void setValue(Object value) {
    this.value = value;
  }

  /**
   * <p>Getter for the field <code>order</code>.</p>
   *
   * @return a int.
   */
  public int getOrder() {
    return order;
  }

  /**
   * <p>Setter for the field <code>order</code>.</p>
   *
   * @param order a int.
   */
  public void setOrder(int order) {
    this.order = order;
  }

  /**
   * Provides name of the parameter type.
   *
   * @return Parameter type name.
   */
  public String getTypeName() {
    return typeName;
  }

  /**
   * <p>Setter for the field <code>typeName</code>.</p>
   *
   * @param typeName a {@link java.lang.String} object.
   */
  public void setTypeName(String typeName) {
    this.typeName = typeName;
  }

  /**
   * <p>Getter for the field <code>parent</code>.</p>
   *
   * @return a {@link org.appops.core.service.meta.ServiceOpMeta} object.
   */
  public ServiceOpMeta getParent() {
    return parent;
  }

  /**
   * <p>Setter for the field <code>parent</code>.</p>
   *
   * @param parent a {@link org.appops.core.service.meta.ServiceOpMeta} object.
   */
  public void setParent(ServiceOpMeta parent) {
    this.parent = parent;
  }
}
