/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.core.service;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.appops.configuration.ContainerConfig;
import org.appops.configuration.ModuleConfig;
import org.appops.core.exception.CoreException;

/**
 * Service/Service-container configuration.
 *
 * @author deba
 * @version $Id: $Id
 */
@Deprecated
public class ServiceConfig {

  private String serviceUrl;
  private File webappDirectory;

  @JsonIgnoreProperties
  private String image = "";
  private Class<?> annotationClass;
  private ExecutionMode executionMode;
  private String serviceName = "";
  private ModuleConfig moduleConfig;
  private ContainerConfig containerConfig;
  private String contextPath = "";
  private String appConfigPath;


  /**
   * Default constructor.
   */
  public ServiceConfig() {
    setWebappDirectory(new File("app/webapp"));
    setServiceUrl("http://localhost:8080/");
    setExecutionMode(ExecutionMode.SERVICE);
    setAppConfigPath("app-config.json");
  }

  /**
   * <p>
   * Constructor for ServiceConfig.
   * </p>
   *
   * @param serviceName a {@link java.lang.String} object.
   */
  public ServiceConfig(String serviceName) {
    this();
    setServiceName(serviceName);
  }

  /**
   * Object constructor.
   *
   * @param name Service name.
   * @param image Service image path.
   */
  public ServiceConfig(String name, String image) {
    this();
    setImage(image);
    setServiceName(name);
  }

  /**
   * <p>
   * contextPath.
   * </p>
   *
   * @return a {@link java.lang.String} object.
   */
  public String contextPath() {
    return qualifiedUrl().getPath();
  }

  /**
   * <p>
   * port.
   * </p>
   *
   * @return a int.
   */
  public int port() {
    int port = qualifiedUrl().getPort();
    return port <= 0 ? 80 : port;
  }

  /**
   * Validates and returns qualified service url.
   *
   * @return Validated, qualified service url.
   */
  protected URL qualifiedUrl() {
    try {
      URL url = new URL(getServiceUrl());
      return url;
    } catch (MalformedURLException e) {
      throw new CoreException(e);
    }
  }

  /**
   * <p>
   * Getter for the field <code>serviceUrl</code>.
   * </p>
   *
   * @return a {@link java.lang.String} object.
   */
  public String getServiceUrl() {
    return serviceUrl;
  }

  /**
   * <p>
   * Setter for the field <code>serviceUrl</code>.
   * </p>
   *
   * @param serviceUrl a {@link java.lang.String} object.
   */
  public void setServiceUrl(String serviceUrl) {
    this.serviceUrl = serviceUrl;
  }

  /**
   * <p>
   * Getter for the field <code>webappDirectory</code>.
   * </p>
   *
   * @return a {@link java.io.File} object.
   */
  public File getWebappDirectory() {
    return webappDirectory;
  }

  /**
   * <p>
   * Setter for the field <code>webappDirectory</code>.
   * </p>
   *
   * @param webappDirectory a {@link java.io.File} object.
   */
  public void setWebappDirectory(File webappDirectory) {
    this.webappDirectory = webappDirectory;
  }

  /**
   * <p>
   * Getter for the field <code>image</code>.
   * </p>
   *
   * @return a {@link java.lang.String} object.
   */
  public String getImage() {
    return image;
  }

  /**
   * <p>
   * Setter for the field <code>image</code>.
   * </p>
   *
   * @param image a {@link java.lang.String} object.
   */
  public void setImage(String image) {
    this.image = image;
  }

  /**
   * <p>
   * Getter for the field <code>annotationClass</code>.
   * </p>
   *
   * @return a {@link java.lang.Class} object.
   */
  public Class<?> getAnnotationClass() {
    return annotationClass;
  }

  /**
   * <p>
   * Setter for the field <code>annotationClass</code>.
   * </p>
   *
   * @param annotationClass a {@link java.lang.Class} object.
   */
  public void setAnnotationClass(Class<?> annotationClass) {
    this.annotationClass = annotationClass;
  }

  /**
   * <p>
   * Getter for the field <code>executionMode</code>.
   * </p>
   *
   * @return a {@link org.appops.core.service.ExecutionMode} object.
   */
  public ExecutionMode getExecutionMode() {
    return executionMode;
  }

  /**
   * <p>
   * Setter for the field <code>executionMode</code>.
   * </p>
   *
   * @param executionMode a {@link org.appops.core.service.ExecutionMode} object.
   */
  public void setExecutionMode(ExecutionMode executionMode) {
    this.executionMode = executionMode;
  }

  /**
   * <p>
   * Getter for the field <code>serviceName</code>.
   * </p>
   *
   * @return a {@link java.lang.String} object.
   */
  public String getServiceName() {
    return serviceName;
  }

  /**
   * <p>
   * Setter for the field <code>serviceName</code>.
   * </p>
   *
   * @param serviceName a {@link java.lang.String} object.
   */
  public void setServiceName(String serviceName) {
    this.serviceName = serviceName;
  }

  /**
   * <p>
   * Getter for the field <code>moduleConfig</code>.
   * </p>
   *
   * @return a {@link org.appops.configuration.ModuleConfig} object.
   */
  public ModuleConfig getModuleConfig() {
    return moduleConfig;
  }

  /**
   * <p>
   * Setter for the field <code>moduleConfig</code>.
   * </p>
   *
   * @param moduleConfig a {@link org.appops.configuration.ModuleConfig} object.
   */
  public void setModuleConfig(ModuleConfig moduleConfig) {
    this.moduleConfig = moduleConfig;
  }

  /**
   * <p>
   * Getter for the field <code>containerConfig</code>.
   * </p>
   *
   * @return a {@link org.appops.configuration.ContainerConfig} object.
   */
  public ContainerConfig getContainerConfig() {
    return containerConfig;
  }

  /**
   * <p>
   * Setter for the field <code>containerConfig</code>.
   * </p>
   *
   * @param containerConfig a {@link org.appops.configuration.ContainerConfig} object.
   */
  public void setContainerConfig(ContainerConfig containerConfig) {
    this.containerConfig = containerConfig;
  }

  /**
   * <p>
   * Getter for the field <code>contextPath</code>.
   * </p>
   *
   * @return a {@link java.lang.String} object.
   */
  public String getContextPath() {
    return (contextPath == null || contextPath.isEmpty()) ? serviceName : contextPath;
  }

  /**
   * <p>
   * Setter for the field <code>contextPath</code>.
   * </p>
   *
   * @param contextPath a {@link java.lang.String} object.
   */
  public void setContextPath(String contextPath) {
    this.contextPath = contextPath;
  }

  /**
   * <p>
   * Getter for the field <code>appConfigPath</code>.
   * </p>
   *
   * @return a {@link java.lang.String} object.
   */
  public String getAppConfigPath() {
    return appConfigPath;
  }

  /**
   * <p>
   * Setter for the field <code>appConfigPath</code>.
   * </p>
   *
   * @param appConfigPath a {@link java.lang.String} object.
   */
  public void setAppConfigPath(String appConfigPath) {
    this.appConfigPath = appConfigPath;
  }

}
