/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.core.service;

/**
 * Service route configuration, the class dynamically calculate qualified route to reach the service
 * based on route strategy configured.
 *
 * @author deba
 * @version $Id: $Id
 */
public class ServiceRoute {

  private String sourceContext;
  private String serviceUrl;

  ServiceRoute() {

  }

  /**
   * <p>Constructor for ServiceRoute.</p>
   *
   * @param sourceContext a {@link java.lang.String} object.
   * @param serviceUrl a {@link java.lang.String} object.
   */
  public ServiceRoute(String sourceContext, String serviceUrl) {
    setSourceContext(sourceContext);
    setServiceUrl(serviceUrl);
  }

  /**
   * <p>Getter for the field <code>sourceContext</code>.</p>
   *
   * @return a {@link java.lang.String} object.
   */
  public String getSourceContext() {
    return sourceContext;
  }

  /**
   * <p>Setter for the field <code>sourceContext</code>.</p>
   *
   * @param sourceContext a {@link java.lang.String} object.
   */
  public void setSourceContext(String sourceContext) {
    this.sourceContext = sourceContext;
  }

  /**
   * <p>Getter for the field <code>serviceUrl</code>.</p>
   *
   * @return a {@link java.lang.String} object.
   */
  public String getServiceUrl() {
    return serviceUrl;
  }

  /**
   * <p>Setter for the field <code>serviceUrl</code>.</p>
   *
   * @param serviceUrl a {@link java.lang.String} object.
   */
  public void setServiceUrl(String serviceUrl) {
    this.serviceUrl = serviceUrl;
  }


}
