/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.core.service.meta;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.appops.core.annotation.Opinion;

/**
 * Stores definition of appops interface.
 *
 * @author deba
 * @version $Id: $Id
 */
@Opinion(name = "interface")
public class InterfaceMeta {

  private String name;
  private Long id;
  private String qualifiedClassName;
  private Set<ServiceOpMeta> operations = new HashSet<>();
  private ServiceMeta parent = new ServiceMeta();


  /**
   * <p>addOperation.</p>
   *
   * @param operation a {@link org.appops.core.service.meta.ServiceOpMeta} object.
   */
  public void addOperation(ServiceOpMeta operation) {
    operations.add(operation);
  }

  /**
   * <p>Getter for the field <code>name</code>.</p>
   *
   * @return a {@link java.lang.String} object.
   */
  public String getName() {
    return name;
  }

  /**
   * <p>Setter for the field <code>name</code>.</p>
   *
   * @param name a {@link java.lang.String} object.
   */
  public void setName(String name) {
    this.name = name;
  }

  /**
   * <p>Getter for the field <code>id</code>.</p>
   *
   * @return a {@link java.lang.Long} object.
   */
  public Long getId() {
    return id;
  }

  /**
   * <p>Setter for the field <code>id</code>.</p>
   *
   * @param id a {@link java.lang.Long} object.
   */
  public void setId(Long id) {
    this.id = id;
  }

  /**
   * <p>Getter for the field <code>operations</code>.</p>
   *
   * @return a {@link java.util.Set} object.
   */
  public Set<ServiceOpMeta> getOperations() {
    return operations;
  }

  /**
   * <p>Getter for the field <code>qualifiedClassName</code>.</p>
   *
   * @return a {@link java.lang.String} object.
   */
  public String getQualifiedClassName() {
    return qualifiedClassName;
  }

  /**
   * <p>Setter for the field <code>qualifiedClassName</code>.</p>
   *
   * @param qualifiedClassName a {@link java.lang.String} object.
   */
  public void setQualifiedClassName(String qualifiedClassName) {
    this.qualifiedClassName = qualifiedClassName;
  }

  /**
   * Creates a lightweight copy to avoid cyclic object dependency.
   *
   * @return Lightweight copy of interface meta.
   */
  public InterfaceMeta lightweightCopy() {
    InterfaceMeta interfaceMeta = new InterfaceMeta();
    interfaceMeta.setId(getId());
    interfaceMeta.setName(getName());
    interfaceMeta.setQualifiedClassName(getQualifiedClassName());
    interfaceMeta.setParent(getParent().lightweightCopy());
    return interfaceMeta;
  }

  /**
   * <p>Getter for the field <code>parent</code>.</p>
   *
   * @return a {@link org.appops.core.service.meta.ServiceMeta} object.
   */
  public ServiceMeta getParent() {
    return parent;
  }

  /**
   * <p>Setter for the field <code>parent</code>.</p>
   *
   * @param parent a {@link org.appops.core.service.meta.ServiceMeta} object.
   */
  public void setParent(ServiceMeta parent) {
    this.parent.setId(parent.getId());
    this.parent.setName(parent.getName());
  }

  /**
   * <p>Setter for the field <code>operations</code>.</p>
   *
   * @param operations a {@link java.util.Set} object.
   */
  public void setOperations(Set<ServiceOpMeta> operations) {
    this.operations = operations;
  }

  /**
   * <p>addOperations.</p>
   *
   * @param operations a {@link java.util.Collection} object.
   */
  public void addOperations(Collection<ServiceOpMeta> operations) {
    getOperations().addAll(operations);
  }

}
