/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.core.service.meta;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.appops.core.service.OpParameterMap;
import org.appops.core.service.Parameter;
import org.appops.core.service.RequestMethod;

/**
 * Stores definition of appops operation.
 *
 * @author deba
 * @version $Id: $Id
 */
public class ServiceOpMeta {

  private Long id;
  private String name;
  private String friendly;
  private String path;
  private OpParameterMap parameters = new OpParameterMap();
  private Set<Parameter> parameter = new HashSet<>();
  private boolean isDynamic;
  private RequestMethod method;
  private InterfaceMeta parent;
  private String resultTypeName;
  private Boolean asyncFlag;

  /**
   * <p>
   * addParameter.
   * </p>
   *
   * @param parameter a {@link org.appops.core.service.Parameter} object.
   */
  public void addParameter(Parameter parameter) {
    parameters.put(parameter.getOrder(), parameter);
  }

  /**
   * Strips and provides actual parameter values.
   *
   * @return List of values stripped from parameters.
   */
  public List<Object> strippedParameters() {
    List<Object> params = new ArrayList<>();
    for (Parameter parameter : parameters.values()) {
      params.add(parameter.getValue());
    }
    return params;
  }

  /**
   * Fetches parameter by name.
   *
   * @param name Parameter name.
   * @return Returns parameter if found, null otherwise.
   */
  public Parameter getParameter(String name) {
    for (Parameter param : getParameters().values()) {
      if (param.getName().equals(name)) {
        return param;
      }
    }
    return null;
  }


  /**
   * <p>
   * Getter for the field <code>name</code>.
   * </p>
   *
   * @return a {@link java.lang.String} object.
   */
  public String getName() {
    return name;
  }

  /**
   * <p>
   * Setter for the field <code>name</code>.
   * </p>
   *
   * @param name a {@link java.lang.String} object.
   */
  public void setName(String name) {
    this.name = name;
  }

  /**
   * <p>
   * Getter for the field <code>friendly</code>.
   * </p>
   *
   * @return a {@link java.lang.String} object.
   */
  public String getFriendly() {
    return friendly;
  }

  /**
   * <p>
   * Setter for the field <code>friendly</code>.
   * </p>
   *
   * @param friendly a {@link java.lang.String} object.
   */
  public void setFriendly(String friendly) {
    this.friendly = friendly;
  }



  /**
   * <p>
   * Getter for the field <code>id</code>.
   * </p>
   *
   * @return a {@link java.lang.Long} object.
   */
  public Long getId() {
    return id;
  }


  /**
   * <p>
   * Setter for the field <code>id</code>.
   * </p>
   *
   * @param id a {@link java.lang.Long} object.
   */
  public void setId(Long id) {
    this.id = id;
  }

  /**
   * <p>
   * isDynamic.
   * </p>
   *
   * @return a boolean.
   */
  public boolean isDynamic() {
    return isDynamic;
  }

  /**
   * <p>
   * setDynamic.
   * </p>
   *
   * @param isDynamic a boolean.
   */
  public void setDynamic(boolean isDynamic) {
    this.isDynamic = isDynamic;
  }

  /**
   * <p>
   * Getter for the field <code>parameters</code>.
   * </p>
   *
   * @return a {@link org.appops.core.service.OpParameterMap} object.
   */
  public OpParameterMap getParameters() {
    return parameters;
  }

  /**
   * <p>
   * Setter for the field <code>parameters</code>.
   * </p>
   *
   * @param parameters a {@link org.appops.core.service.OpParameterMap} object.
   */
  public void setParameters(OpParameterMap parameters) {
    this.parameters = parameters;
  }

  /**
   * <p>
   * addParameters.
   * </p>
   *
   * @param param a {@link org.appops.core.service.Parameter} object.
   */
  public void addParameters(Parameter param) {
    parameter.add(param);
  }

  /**
   * <p>
   * getParameterSet.
   * </p>
   *
   * @return a {@link java.util.Set} object.
   */
  public Set<Parameter> getParameterSet() {
    return parameter;
  }

  /**
   * <p>
   * Getter for the field <code>parent</code>.
   * </p>
   *
   * @return a {@link org.appops.core.service.meta.InterfaceMeta} object.
   */
  public InterfaceMeta getParent() {
    return parent;
  }

  /**
   * <p>
   * Setter for the field <code>parent</code>.
   * </p>
   *
   * @param parent a {@link org.appops.core.service.meta.InterfaceMeta} object.
   */
  public void setParent(InterfaceMeta parent) {
    this.parent = parent;
  }

  /**
   * <p>
   * Getter for the field <code>path</code>.
   * </p>
   *
   * @return a {@link java.lang.String} object.
   */
  public String getPath() {
    return path;
  }

  /**
   * <p>
   * Setter for the field <code>path</code>.
   * </p>
   *
   * @param path a {@link java.lang.String} object.
   */
  public void setPath(String path) {
    this.path = path;
  }

  /**
   * <p>
   * Getter for the field <code>method</code>.
   * </p>
   *
   * @return a {@link org.appops.core.service.RequestMethod} object.
   */
  public RequestMethod getMethod() {
    return method;
  }

  /**
   * <p>
   * Setter for the field <code>method</code>.
   * </p>
   *
   * @param method a {@link org.appops.core.service.RequestMethod} object.
   */
  public void setMethod(RequestMethod method) {
    this.method = method;
  }

  /**
   * Provides parameter types.
   *
   * @return Collection of qualified name of each parameter type.
   */
  public Collection<String> parameterTypes() {
    List<String> typeList = new ArrayList<>();
    for (Parameter parameter : getParameters().values()) {
      typeList.add(parameter.getTypeName());
    }
    return typeList;
  }


  /**
   * <p>
   * serviceMeta.
   * </p>
   *
   * @return a {@link org.appops.core.service.meta.ServiceMeta} object.
   */
  public ServiceMeta serviceMeta() {
    return getParent().getParent();
  }

  /**
   * <p>
   * serviceName.
   * </p>
   *
   * @return a {@link java.lang.String} object.
   */
  public String serviceName() {
    return serviceMeta().getName();
  }

  /**
   * <p>
   * Getter for the field <code>resultTypeName</code>.
   * </p>
   *
   * @return a {@link java.lang.String} object.
   */
  public String getResultTypeName() {
    return resultTypeName;
  }

  /**
   * <p>
   * Setter for the field <code>resultTypeName</code>.
   * </p>
   *
   * @param resultTypeName a {@link java.lang.String} object.
   */
  public void setResultTypeName(String resultTypeName) {
    this.resultTypeName = resultTypeName;
  }

  /**
   * Creates a simple, lightweight copy of op meta.
   *
   * @return Lightweight copy.
   */
  public ServiceOpMeta lightweightCopy() {
    ServiceOpMeta lightweightCopy = new ServiceOpMeta();
    lightweightCopy.setId(getId());
    lightweightCopy.setName(getName());
    lightweightCopy.setParent(getParent().lightweightCopy());
    lightweightCopy.setDynamic(isDynamic());
    lightweightCopy.setFriendly(getFriendly());
    lightweightCopy.setMethod(getMethod());
    lightweightCopy.setResultTypeName(getResultTypeName());
    lightweightCopy.setPath(getPath());
    lightweightCopy.setAsyncFlag(isAsyncFlag());
    return lightweightCopy;
  }

  /**
   * <p>
   * Getter for the field <code>asyncFlag</code>.
   * </p>
   *
   * @return a {@link java.lang.Boolean} object.
   */
  public Boolean isAsyncFlag() {
    return asyncFlag;
  }

  /**
   * <p>
   * Setter for the field <code>asyncFlag</code>.
   * </p>
   *
   * @param asyncFlag a {@link java.lang.Boolean} object.
   */
  public void setAsyncFlag(Boolean asyncFlag) {
    this.asyncFlag = asyncFlag;
  }


}
