/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.core.util;

import java.io.File;
import java.io.FileOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.appops.core.exception.CoreException;

/**
 * <p>ZipUtils class.</p>
 *
 * @author deba
 * @version $Id: $Id
 */
public class ZipUtils {

  /**
   * <p>zip.</p>
   *
   * @param sourceFolder a {@link java.io.File} object.
   * @param outputFile a {@link java.io.File} object.
   */
  public void zip(File sourceFolder, File outputFile) {
    zip(new File[] {sourceFolder}, outputFile);
  }


  /**
   * Zips list of files passed.
   *
   * @param files List of files to be zipped.
   * @param outputFile Path of output zip file.
   */
  public void zip(File[] files, File outputFile) {
    try (ZipOutputStream out = new ZipOutputStream(new FileOutputStream(outputFile))) {
      addEntries(files, out);
    } catch (Exception e) {
      throw new CoreException(e);
    }
  }

  /**
   * Adds entries to zip.
   * 
   * @param files List of files to be added.
   * @param out Zip output stream.
   */
  private void addEntries(File[] files, ZipOutputStream out) {
    for (File file : files) {
      try {
        if (file.isDirectory()) {
          addEntries(file.listFiles(), out);
        } else {
          ZipEntry e = new ZipEntry(file.getPath());
          out.putNextEntry(e);
        }
      } catch (Exception e) {
        continue;
      }
    }
  }


}
