/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.marshaller;

import org.apache.commons.io.FilenameUtils;
import org.appops.core.constant.IterableConstant;
import org.appops.core.exception.CoreException;

/**
 * Constant class which has declarations of types/mechanisms supported for marshalling and
 * unmarshalling in appops. e.g. Json, Xml etc.
 *
 * @author deba
 * @version $Id: $Id
 */
public class DescriptorType extends IterableConstant<String> {

  /**
   * <p>Constructor for DescriptorType.</p>
   *
   * @param value a {@link java.lang.String} object.
   */
  protected DescriptorType(String value) {
    super(value);
  }

  /** Constant <code>JSON</code> */
  public static final DescriptorType JSON = new DescriptorType("json");
  /** Constant <code>XML</code> */
  public static final DescriptorType XML = new DescriptorType("xml");
  /** Constant <code>YML</code> */
  public static final DescriptorType YML = new DescriptorType("yml");


  /**
   * Identifies and provides type of marshaller to be used using file extension.
   *
   * @param filename Name of file along with extension.
   * @return Type of marshaller to be used for a file.
   */
  public static DescriptorType fromExtension(String filename) {
    String extension = FilenameUtils.getExtension(filename);
    if (JSON.value().equalsIgnoreCase(extension)) {
      return JSON;
    } else if (XML.value().equalsIgnoreCase(extension)) {
      return XML;
    } else if (YML.value().equalsIgnoreCase(extension)) {
      return YML;
    } else {
      throw new CoreException("No marshaller type is supported for file type -> " + extension);
    }
  }

}
