/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.marshaller;

/**
 * Generic marshaling class which has ability to marshal and unmarshal value by using provided
 * algorithm/type of marshaler e.g. JSON, XML etc.
 *
 * @author deba
 * @version $Id: $Id
 */
public interface Marshaller {

  /**
   * Marshals provided value using provided marshaling mechanism.
   *
   * @param object Value which is to be marshaled.
   * @param marshaller Unmarshaling mechanism to be used e.g. JSON, XML etc.
   * @return Marshaled value.
   */
  public String marshall(Object object, DescriptorType marshaller);

  /**
   * Unmarshals provided value using provided marshaling mechanism.
   *
   * @param marshalledData Value which is to be unmarshaled.
   * @param clazz Type into which data is to be unmarshaled.
   * @param unmarshaller Mechanism used while marshaling data e.g. JSON, XML etc.
   * @param <T> Type of unmarshaled value.
   * @return Unmarshaled value.
   */
  public <T> T unmarshall(String marshalledData, Class<T> clazz, DescriptorType unmarshaller);

}
