/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.marshaller.xml;

/**
 * <p>XmlMarshaller interface.</p>
 *
 * @author deba
 * @version $Id: $Id
 */
public interface XmlMarshaller {

  /**
   * Converts provided object into XML form.
   *
   * @param object Value which is to be converted into Xml.
   * @return Xml value.
   */
  public String toXml(Object object);

  /**
   * Converts xml value into java object.
   *
   * @param xml XML which is to be deserialized.
   * @param clazz Class of result.
   * @param <T> Type of deserialized object.
   * @return Deserialized java object.
   */
  public <T> T fromXml(String xml, Class<T> clazz);
}
