package org.appops.configuration.provider;

import java.lang.annotation.Annotation;

import org.appops.configuration.store.CurrentRunningServiceContext;
import org.appops.core.deployment.ServiceConfiguration;

import com.google.inject.Inject;

/**
 * This class is to provide current context related information .
 * 
 */
public class RunningServiceContextProvider {
	private CurrentRunningServiceContext currentRunningServiceContext;

	/**
	 * <p>
	 * Constructor for RunningServiceContextProvider.
	 * </p>
	 *
	 * @param runningServiceContextProvider a {@link CurrentRunningServiceContext}
	 *                                      object.
	 */
	@Inject
	public RunningServiceContextProvider(CurrentRunningServiceContext runningServiceContextProvider) {
		this.currentRunningServiceContext = runningServiceContextProvider;
	}

	/**
	 * get running service name
	 * 
	 * @return Service Name
	 */
	public String getRunningServiceName() {
		return currentRunningServiceContext.getCurrentRunningService();
	}

	/**
	 * get Service configuration from context.
	 * 
	 * @return {@link ServiceConfiguration}.
	 */
	public ServiceConfiguration getRunningServiceConfiguration() {
		return currentRunningServiceContext.getServiceConfiguration();
	}

	/**
	 * get annotation class of current service .
	 * 
	 * @return annotation class
	 */
	public Class<? extends Annotation> getRunningServiceAnnaotation() {
		return currentRunningServiceContext.getServiceAnnotation();
	}
}
