/*
 * Decompiled with CFR 0.152.
 */
package org.appops.log.service.impl;

import com.google.inject.Inject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.appops.log.service.slim.service.Level;
import org.appops.log.service.slim.service.LogMeta;
import org.appops.log.service.slim.service.LogServiceManager;
import org.appops.marshaller.Marshaller;

public class LogServiceManagerImpl
implements LogServiceManager {
    private Marshaller marshaller;
    private Map<Integer, LogMeta> logRecords = new TreeMap<Integer, LogMeta>();

    public void addLogRecord(LogMeta logRecord) {
        this.logRecords.put(this.logRecords.size() + 1, logRecord);
    }

    public Collection<LogMeta> getAllLogRecords() {
        return this.logRecords.values();
    }

    public Collection<LogMeta> filterByKeyword(String keyword) {
        ArrayList<LogMeta> listToReturn = new ArrayList<LogMeta>();
        for (LogMeta logRecord : this.logRecords.values()) {
            Map logMetaMap = logRecord.getMetaMap();
            for (Object value : logMetaMap.values()) {
                if (!String.valueOf(value).contains(keyword)) continue;
                listToReturn.add(logRecord);
            }
        }
        return listToReturn;
    }

    public Collection<LogMeta> filterByLevel(Level expectedLevel) {
        ArrayList<LogMeta> listToReturn = new ArrayList<LogMeta>();
        if (expectedLevel == null) {
            return listToReturn;
        }
        for (LogMeta logRecord : this.logRecords.values()) {
            Level level = (Level)logRecord.getMetaMap().get(LogMeta.LEVEL.value());
            if (!expectedLevel.equals((Object)level) && !expectedLevel.equals((Object)Level.ALL)) continue;
            listToReturn.add(logRecord);
        }
        return listToReturn;
    }

    public Collection<LogMeta> getLogRecordsByPage(Integer startIndex, Integer pageSize) {
        ArrayList<LogMeta> listToReturn = new ArrayList<LogMeta>();
        int endIndex = startIndex + pageSize;
        for (Integer index : this.logRecords.keySet()) {
            if (index < startIndex || index >= endIndex) continue;
            listToReturn.add(this.logRecords.get(index));
        }
        return listToReturn;
    }

    public Collection<LogMeta> getLogRecordsByStartDate(String startDateOfLog) {
        ArrayList<LogMeta> listToReturn = new ArrayList<LogMeta>();
        Date startDate = null;
        startDateOfLog = startDateOfLog.substring(0, 9);
        SimpleDateFormat format = new SimpleDateFormat("MMMddyyyy", Locale.ENGLISH);
        try {
            startDate = format.parse(startDateOfLog);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        for (LogMeta logRecord : this.logRecords.values()) {
            Map logMetaMap = logRecord.getMetaMap();
            for (Object key : logMetaMap.keySet()) {
                if (!key.equals("datetime")) continue;
                String dateValue = (String)logMetaMap.get(key);
                dateValue = dateValue.substring(0, 13);
                dateValue = dateValue.replace(",", "");
                SimpleDateFormat format2 = new SimpleDateFormat("MMM dd yyyy", Locale.ENGLISH);
                try {
                    Date date2 = format2.parse(dateValue);
                    if (date2.compareTo(startDate) < 0) continue;
                    listToReturn.add(logRecord);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        }
        return listToReturn;
    }

    public Collection<LogMeta> getLogRecords(String startLogDate, String endLogDate) {
        ArrayList<LogMeta> listToReturn = new ArrayList<LogMeta>();
        Date startDate = null;
        Date endDate = null;
        startLogDate = startLogDate.substring(0, 9);
        endLogDate = endLogDate.substring(0, 9);
        SimpleDateFormat format = new SimpleDateFormat("MMMddyyyy", Locale.ENGLISH);
        try {
            startDate = format.parse(startLogDate);
            endDate = format.parse(endLogDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        for (LogMeta logRecord : this.logRecords.values()) {
            Map logMetaMap = logRecord.getMetaMap();
            for (Object key : logMetaMap.keySet()) {
                if (!key.equals("datetime")) continue;
                String dateValue = (String)logMetaMap.get(key);
                dateValue = dateValue.substring(0, 13);
                dateValue = dateValue.replace(",", "");
                SimpleDateFormat format2 = new SimpleDateFormat("MMM dd yyyy", Locale.ENGLISH);
                try {
                    Date logListDate = format2.parse(dateValue);
                    if (logListDate.compareTo(startDate) < 0 || logListDate.compareTo(endDate) > 0) continue;
                    listToReturn.add(logRecord);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        }
        return listToReturn;
    }

    public Collection<LogMeta> getLogRecordsByStartTime(String startTime) {
        ArrayList<LogMeta> listToReturn = new ArrayList<LogMeta>();
        LocalTime startLocalTime = null;
        startLocalTime = LocalTime.parse(startTime);
        for (LogMeta logRecord : this.logRecords.values()) {
            Map logMetaMap = logRecord.getMetaMap();
            for (Object key : logMetaMap.keySet()) {
                if (!key.equals("datetime")) continue;
                String timeValue = (String)logMetaMap.get(key);
                LocalTime logListTime = LocalTime.parse(timeValue = timeValue.substring(13, 21));
                if (logListTime.compareTo(startLocalTime) < 0) continue;
                listToReturn.add(logRecord);
            }
        }
        return listToReturn;
    }

    public Collection<LogMeta> getLogRecordsByStartTimeEndTime(String startTime, String endTime) {
        ArrayList<LogMeta> listToReturn = new ArrayList<LogMeta>();
        LocalTime startLocalTime = null;
        LocalTime endLocalTime = null;
        startLocalTime = LocalTime.parse(startTime);
        endLocalTime = LocalTime.parse(endTime);
        for (LogMeta logRecord : this.logRecords.values()) {
            Map logMetaMap = logRecord.getMetaMap();
            for (Object key : logMetaMap.keySet()) {
                if (!key.equals("datetime")) continue;
                String timeValue = (String)logMetaMap.get(key);
                LocalTime logsTime = LocalTime.parse(timeValue = timeValue.substring(13, 21));
                if (logsTime.compareTo(startLocalTime) < 0 || logsTime.compareTo(endLocalTime) > 0) continue;
                listToReturn.add(logRecord);
            }
        }
        return listToReturn;
    }

    public Collection<LogMeta> getLogRecordsByDateAndTime(String startDateOfLog, String endDateOfLog, String startTime, String endTime) {
        Date startDate = null;
        Date endDate = null;
        startDateOfLog = startDateOfLog.substring(0, 9);
        endDateOfLog = endDateOfLog.substring(0, 9);
        SimpleDateFormat format = new SimpleDateFormat("MMMddyyyy", Locale.ENGLISH);
        try {
            startDate = format.parse(startDateOfLog);
            endDate = format.parse(endDateOfLog);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        LocalTime startLocalTime = null;
        startLocalTime = LocalTime.parse(startTime);
        LocalTime endLocalTime = null;
        endLocalTime = LocalTime.parse(endTime);
        List<LogMeta> sortedDates = this.getFilteredDateListOfDateTime(startDate, endDate);
        ArrayList<LogMeta> listToReturn = new ArrayList();
        listToReturn = this.getFinalFilteredListOfDateTime(startLocalTime, endLocalTime, sortedDates);
        return listToReturn;
    }

    public List<LogMeta> getFilteredDateListOfDateTime(Date startDateLog, Date endDateLog) {
        ArrayList<LogMeta> sortedDateList = new ArrayList<LogMeta>();
        for (LogMeta logRecord : this.logRecords.values()) {
            Map logMetaMap = logRecord.getMetaMap();
            for (Object key : logMetaMap.keySet()) {
                if (!key.equals("datetime")) continue;
                String dateValue = (String)logMetaMap.get(key);
                dateValue = dateValue.substring(0, 13);
                dateValue = dateValue.replace(",", "");
                SimpleDateFormat format2 = new SimpleDateFormat("MMM dd yyyy", Locale.ENGLISH);
                try {
                    Date logsDate = format2.parse(dateValue);
                    if (logsDate.compareTo(startDateLog) < 0 || logsDate.compareTo(endDateLog) > 0) continue;
                    sortedDateList.add(logRecord);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        }
        return sortedDateList;
    }

    public List<LogMeta> getFinalFilteredListOfDateTime(LocalTime startTime, LocalTime endTime, Collection<LogMeta> sortedDateList) {
        ArrayList<LogMeta> listToReturn = new ArrayList<LogMeta>();
        for (LogMeta element : sortedDateList) {
            Map logMetaMap = element.getMetaMap();
            for (Object key : logMetaMap.keySet()) {
                if (!key.equals("datetime")) continue;
                String timeValue = (String)logMetaMap.get(key);
                LocalTime logListTime = LocalTime.parse(timeValue = timeValue.substring(13, 21));
                if (logListTime.compareTo(startTime) < 0 || logListTime.compareTo(endTime) > 0) continue;
                listToReturn.add(element);
            }
        }
        return listToReturn;
    }

    public void removeOlderLogs() {
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    @Inject
    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }
}

