/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.logging.logger.config;

import java.text.SimpleDateFormat;
import java.util.Calendar;

/**
 * <p>StorageConfig class.</p>
 *
 * @author deba
 * @version $Id: $Id
 */
public class StorageConfig {
  private String filepath;
  private String maxFileSize;
  private String ttl;

  /**
   * Constructor.
   */
  public StorageConfig() {
    Calendar cal = Calendar.getInstance();
    cal.add(Calendar.DATE, -7);
    SimpleDateFormat formatter = new SimpleDateFormat("MMM dd,yyyy");
    String dateString = formatter.format(cal.getTime());
    setTtl(dateString);
  }

  /**
   * <p>Getter for the field <code>filepath</code>.</p>
   *
   * @return a {@link java.lang.String} object.
   */
  public String getFilepath() {
    return filepath;
  }

  /**
   * <p>Setter for the field <code>filepath</code>.</p>
   *
   * @param filepath a {@link java.lang.String} object.
   */
  public void setFilepath(String filepath) {
    this.filepath = filepath;
  }

  /**
   * <p>Getter for the field <code>maxFileSize</code>.</p>
   *
   * @return a {@link java.lang.String} object.
   */
  public String getMaxFileSize() {
    return maxFileSize;
  }

  /**
   * <p>Setter for the field <code>maxFileSize</code>.</p>
   *
   * @param maxFileSize a {@link java.lang.String} object.
   */
  public void setMaxFileSize(String maxFileSize) {
    this.maxFileSize = maxFileSize;
  }

  /**
   * <p>Getter for the field <code>ttl</code>.</p>
   *
   * @return a {@link java.lang.String} object.
   */
  public String getTtl() {
    return ttl;
  }

  /**
   * <p>Setter for the field <code>ttl</code>.</p>
   *
   * @param ttl a {@link java.lang.String} object.
   */
  public void setTtl(String ttl) {
    this.ttl = ttl;
  }
}
