/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.logging.destination;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.appops.core.annotation.Config;
import org.appops.logging.logger.config.LoggerConfig;

/**
 * Guice based provider class which reads logger configuration and provides destination logger
 * instance accordingly.
 *
 * @author deba
 * @version $Id: $Id
 */
public class DestinationLoggerProvider implements Provider<DestinationLogger> {
  private LoggerConfig config;
  private DestinationLoggerStore destinationLoggerStore;

  /** {@inheritDoc} */
  @Override
  public DestinationLogger get() {
    return getDestinationLoggerStore().get();
  }

  /**
   * <p>Getter for the field <code>config</code>.</p>
   *
   * @return a {@link org.appops.logging.logger.config.LoggerConfig} object.
   */
  public LoggerConfig getConfig() {
    return config;
  }

  /**
   * <p>Setter for the field <code>config</code>.</p>
   *
   * @param config a {@link org.appops.logging.logger.config.LoggerConfig} object.
   */
  @Inject
  public void setConfig(@Config LoggerConfig config) {
    this.config = config;
  }

  /**
   * <p>Getter for the field <code>destinationLoggerStore</code>.</p>
   *
   * @return a {@link org.appops.logging.destination.DestinationLoggerStore} object.
   */
  public DestinationLoggerStore getDestinationLoggerStore() {
    return destinationLoggerStore;
  }

  /**
   * <p>Setter for the field <code>destinationLoggerStore</code>.</p>
   *
   * @param destinationLoggerStore a {@link org.appops.logging.destination.DestinationLoggerStore} object.
   */
  @Inject
  public void setDestinationLoggerStore(DestinationLoggerStore destinationLoggerStore) {
    this.destinationLoggerStore = destinationLoggerStore;
  }

}
