/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.logging.destination;

import java.util.List;
import org.appops.logging.logger.Logger;
import org.appops.logging.logger.config.HandlerConfig;
import org.appops.logging.logger.config.constant.LoggerType;
import org.appops.logging.meta.Level;
import org.appops.logging.meta.LogMeta;

/**
 * <p>NoOpLogger class.</p>
 *
 * @author deba
 * @version $Id: $Id
 */
public class NoOpLogger extends DestinationLogger implements Logger {

  /** {@inheritDoc} */
  @Override
  public boolean log(Level level, String message) {
    return true;
  }

  /** {@inheritDoc} */
  @Override
  public boolean log() {
    return true;
  }

  /** {@inheritDoc} */
  @Override
  public LoggerType type() {
    return LoggerType.NO_OP;
  }

  /** {@inheritDoc} */
  @Override
  protected Object internalLogger() {
    return null;
  }


  /** {@inheritDoc} */
  @Override
  public Logger withLevel(Level level) {
    return this;
  }

  /** {@inheritDoc} */
  @Override
  public Logger withMessage(String message) {
    return this;
  }

  /** {@inheritDoc} */
  @Override
  public Logger withMeta(LogMeta meta) {
    return this;
  }

  /** {@inheritDoc} */
  @Override
  public Logger withMeta(String key, Object value) {
    return this;
  }

  /** {@inheritDoc} */
  @Override
  public void removeAllHandlers() {

  }

  /** {@inheritDoc} */
  @Override
  public void addHandlers(List handlers) {

  }

  /** {@inheritDoc} */
  @Override
  public void addHandler(HandlerConfig handler) {

  }

  /** {@inheritDoc} */
  @Override
  protected String formatPattern(String pattern) {
    return null;
  }

  /** {@inheritDoc} */
  @Override
  public Logger setLoggerName(String loggerName) {
    // TODO Auto-generated method stub
    return null;
  }



}
