/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.logging.guice;

import com.google.inject.Singleton;
import com.google.inject.name.Names;
import org.appops.core.CoreModule;
import org.appops.logging.destination.DestinationLogger;
import org.appops.logging.destination.DestinationLoggerProvider;
import org.appops.logging.destination.DestinationLoggerStore;
import org.appops.logging.impl.AppopsRootLogger;
import org.appops.logging.impl.LoggerImpl;
import org.appops.logging.logger.Logger;

/**
 * <p>Abstract BaseLoggerModule class.</p>
 *
 * @author deba
 * @version $Id: $Id
 */
public abstract class BaseLoggerModule extends CoreModule {


  /** {@inheritDoc} */
  @Override
  public void configure() {
    bind(Logger.class).to(LoggerImpl.class);
    bind(DestinationLogger.class).toProvider(DestinationLoggerProvider.class);
    bind(Logger.class).annotatedWith(Names.named(AppopsRootLogger.NAME)).to(AppopsRootLogger.class)
        .in(Singleton.class);
    bind(DestinationLoggerStore.class).in(Singleton.class);
  }
}
