/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.logging.logger.config;

import java.util.ArrayList;
import java.util.List;
import org.appops.core.annotation.CoreConfig;
import org.appops.logging.logger.config.constant.HandlerAttribute;
import org.appops.logging.logger.config.constant.HandlerType;
import org.appops.logging.logger.config.constant.LoggerType;
import org.appops.logging.meta.Level;

/**
 * General configuration required which is to be used while creating logger instance.
 *
 * @author deba
 * @version $Id: $Id
 */

@CoreConfig
public class LoggerConfig {
  private LoggerType destinationLogger;
  private List<HandlerConfig> handlers;
  private List<LoggerType> overrideLoggers;

  private boolean aggregateLogs = false;
  private Level level;
  private StorageConfig storage;

  /**
   * <p>
   * Getter for the field <code>overrideLoggers</code>.
   * </p>
   *
   * @return a {@link java.util.List} object.
   */
  public List<LoggerType> getOverrideLoggers() {
    return overrideLoggers;
  }

  /**
   * Constructor.
   */
  public LoggerConfig() {
    setDestinationLogger(LoggerType.LOG4J);
    setLevel(Level.ALL);
    addDefaultHandler();
    addDefaultStorage();
  }

  /**
   * A method which adds default log storage.
   */
  private void addDefaultStorage() {
    StorageConfig storageConfig = new StorageConfig();
    storageConfig.setFilepath("LogStorage.log");
    setStorage(storageConfig);
  }

  /**
   * A method which adds default handler.
   */
  public void addDefaultHandler() {
    HandlerConfig config = new HandlerConfig();
    config.enable();
    config.withName(HandlerType.CONSOLE);
    config.addAttribute(HandlerAttribute.LEVEL, Level.ALL);
    getHandlers().add(config);
  }


  /**
   * <p>
   * Setter for the field <code>overrideLoggers</code>.
   * </p>
   *
   * @param overrideLoggers a {@link java.util.List} object.
   */
  public void setOverrideLoggers(List<LoggerType> overrideLoggers) {
    this.overrideLoggers = overrideLoggers;
  }

  /**
   * It returns {@link java.util.List} of {@link org.appops.logging.logger.config.HandlerConfig}.
   *
   * @return {@link java.util.List} of {@link org.appops.logging.logger.config.HandlerConfig}
   */
  public List<HandlerConfig> getHandlers() {
    if (handlers == null) {
      handlers = new ArrayList<HandlerConfig>();
    }
    return handlers;
  }


  /**
   * <p>
   * Setter for the field <code>handlers</code>.
   * </p>
   *
   * @param handlers a {@link java.util.List} object.
   */
  public void setHandlers(List<HandlerConfig> handlers) {
    this.handlers = handlers;
  }


  /**
   * <p>
   * Getter for the field <code>destinationLogger</code>.
   * </p>
   *
   * @return a {@link org.appops.logging.logger.config.constant.LoggerType} object.
   */
  public LoggerType getDestinationLogger() {
    return destinationLogger;
  }


  /**
   * <p>
   * Setter for the field <code>destinationLogger</code>.
   * </p>
   *
   * @param destinationLogger a {@link org.appops.logging.logger.config.constant.LoggerType} object.
   */
  public void setDestinationLogger(LoggerType destinationLogger) {
    this.destinationLogger = destinationLogger;
  }


  /**
   * <p>
   * isAggregateLogs.
   * </p>
   *
   * @return a boolean.
   */
  public boolean isAggregateLogs() {
    return aggregateLogs;
  }


  /**
   * <p>
   * Setter for the field <code>aggregateLogs</code>.
   * </p>
   *
   * @param aggregateLogs a boolean.
   */
  public void setAggregateLogs(boolean aggregateLogs) {
    this.aggregateLogs = aggregateLogs;
  }


  /**
   * <p>
   * Getter for the field <code>level</code>.
   * </p>
   *
   * @return a {@link org.appops.logging.meta.Level} object.
   */
  public Level getLevel() {
    return level;
  }

  /**
   * <p>
   * Setter for the field <code>level</code>.
   * </p>
   *
   * @param level a {@link org.appops.logging.meta.Level} object.
   */
  public void setLevel(Level level) {
    this.level = level;
  }

  /**
   * <p>
   * Getter for the field <code>storage</code>.
   * </p>
   *
   * @return a {@link org.appops.logging.logger.config.StorageConfig} object.
   */
  public StorageConfig getStorage() {
    return storage;
  }

  /**
   * <p>
   * Setter for the field <code>storage</code>.
   * </p>
   *
   * @param storage a {@link org.appops.logging.logger.config.StorageConfig} object.
   */
  public void setStorage(StorageConfig storage) {
    this.storage = storage;
  }



}
