/*
 * Decompiled with CFR 0.152.
 */
package org.appops.logging.destination;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.HashMap;
import org.appops.core.annotation.Config;
import org.appops.logging.destination.DestinationLogger;
import org.appops.logging.destination.JavaUtilLogger;
import org.appops.logging.destination.Log4jLogger;
import org.appops.logging.destination.LogbackLogger;
import org.appops.logging.destination.NoOpLogger;
import org.appops.logging.logger.config.LoggerConfig;
import org.appops.logging.logger.config.constant.LoggerType;

public class DestinationLoggerStore {
    private HashMap<LoggerType, DestinationLogger<?>> destinationLoggers;
    private LoggerConfig config;
    private Provider<NoOpLogger> noOpLogger;

    public DestinationLoggerStore() {
    }

    public void register(DestinationLogger<?> logger) {
        this.getDestinationLoggers().put(logger.type(), logger);
    }

    @Inject
    public DestinationLoggerStore(Provider<Log4jLogger> log4jLogger, Provider<JavaUtilLogger> javaUtilLogger, Provider<LogbackLogger> logbackLogger) {
        this.register((DestinationLogger)log4jLogger.get());
        this.register((DestinationLogger)javaUtilLogger.get());
        this.register((DestinationLogger)logbackLogger.get());
    }

    public DestinationLogger get() {
        LoggerType destinationLogger = this.getConfig().getDestinationLogger();
        if (destinationLogger != null) {
            return this.getDestinationLoggers().get((Object)destinationLogger);
        }
        return this.getNoOpLogger();
    }

    public DestinationLogger<?> get(LoggerType logger) {
        if (logger != null) {
            return this.getDestinationLoggers().get((Object)logger);
        }
        return this.getNoOpLogger();
    }

    public HashMap<LoggerType, DestinationLogger<?>> getDestinationLoggers() {
        if (this.destinationLoggers == null) {
            this.destinationLoggers = new HashMap();
        }
        return this.destinationLoggers;
    }

    public void setDestinationLoggers(HashMap<LoggerType, DestinationLogger<?>> destinationLoggers) {
        this.destinationLoggers = destinationLoggers;
    }

    public LoggerConfig getConfig() {
        return this.config;
    }

    @Inject
    public void setConfig(@Config LoggerConfig config) {
        this.config = config;
    }

    public NoOpLogger getNoOpLogger() {
        return (NoOpLogger)this.noOpLogger.get();
    }

    @Inject
    public void setNoOpLogger(Provider<NoOpLogger> noOpLogger) {
        this.noOpLogger = noOpLogger;
    }
}

