/*
 * Decompiled with CFR 0.152.
 */
package org.appops.logging.destination;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.logging.log4j.LoggingException;
import org.appops.logging.destination.DestinationLogger;
import org.appops.logging.logger.config.HandlerConfig;
import org.appops.logging.logger.config.LogFilter;
import org.appops.logging.logger.config.constant.FilterProperty;
import org.appops.logging.logger.config.constant.FilterReply;
import org.appops.logging.logger.config.constant.FilterType;
import org.appops.logging.logger.config.constant.HandlerAttribute;
import org.appops.logging.logger.config.constant.LoggerType;
import org.appops.logging.meta.Level;

public class Log4jLogger
extends DestinationLogger<Logger> {
    private Logger internalLogger;

    @Override
    public boolean log(Level level, String message) {
        if (level == null) {
            level = Level.ALL;
        }
        this.internalLogger().log((Priority)this.convertLevel(level.name()), (Object)message);
        return true;
    }

    @Override
    public LoggerType type() {
        return LoggerType.LOG4J;
    }

    @Override
    protected Logger internalLogger() {
        if (this.internalLogger == null) {
            this.internalLogger = Logger.getRootLogger();
        }
        return this.internalLogger;
    }

    @Override
    public void addHandlers(List<HandlerConfig> handlers) {
        try {
            if (handlers == null || handlers.isEmpty()) {
                throw new LoggingException("Please provide valid log handlers.");
            }
            for (HandlerConfig handler : handlers) {
                this.addHandler(handler);
            }
        }
        catch (Exception e) {
            throw new LoggingException("Exception Occured while adding handler to ::" + this.getClass().getCanonicalName() + e);
        }
    }

    @Override
    public void addHandler(HandlerConfig handler) {
        if (handler == null) {
            throw new LoggingException("Handler cant't be null");
        }
        if (handler.enabled()) {
            switch (handler.name()) {
                case CONSOLE: {
                    this.addConsoleAppender(handler);
                    break;
                }
                case FILE: {
                    this.addFileAppender(handler);
                    break;
                }
                default: {
                    throw new LoggingException("Please provide valid log handler.");
                }
            }
        }
    }

    @Override
    public void removeAllHandlers() {
        this.internalLogger().removeAllAppenders();
    }

    private void addConsoleAppender(HandlerConfig handler) {
        ConsoleAppender console = new ConsoleAppender();
        Map<HandlerAttribute, Object> config = handler.getConfig();
        String pattern = config.get((Object)HandlerAttribute.PATTERN) != null ? this.formatPattern(config.get((Object)HandlerAttribute.PATTERN).toString()) : "[%-5d] %-5p - %m%n";
        console.setLayout((Layout)new PatternLayout(pattern));
        org.apache.log4j.Level level = org.apache.log4j.Level.ALL;
        if (config.get((Object)HandlerAttribute.LEVEL) != null) {
            level = this.convertLevel(config.get((Object)HandlerAttribute.LEVEL).toString());
        }
        console.setThreshold((Priority)level);
        this.addFilters((Appender)console, handler.getFilters());
        console.activateOptions();
        console.setName(handler.name().name());
        this.internalLogger().addAppender((Appender)console);
    }

    private void addFileAppender(HandlerConfig handlerConfig) {
        Logger logger = this.internalLogger();
        Map<HandlerAttribute, Object> config = handlerConfig.getConfig();
        String filename = config.get((Object)HandlerAttribute.FILENAME) != null ? config.get((Object)HandlerAttribute.FILENAME).toString() : "log4j.log";
        String pattern = config.get((Object)HandlerAttribute.PATTERN) != null ? this.formatPattern(config.get((Object)HandlerAttribute.PATTERN).toString()) : "[%-5d] %-5p - %m%n";
        String maxSize = config.get((Object)HandlerAttribute.MAXSIZE) != null ? config.get((Object)HandlerAttribute.MAXSIZE).toString() : "10MB";
        Integer maxBackupIndex = config.get((Object)HandlerAttribute.MAX_BACKUP_INDEX) != null ? Integer.parseInt(config.get((Object)HandlerAttribute.MAX_BACKUP_INDEX).toString()) : 2;
        org.apache.log4j.Level level = org.apache.log4j.Level.ALL;
        if (config.get((Object)HandlerAttribute.LEVEL) != null) {
            level = this.convertLevel(config.get((Object)HandlerAttribute.LEVEL).toString());
        }
        PatternLayout layout = new PatternLayout(pattern);
        try {
            RollingFileAppender fileHandler = new RollingFileAppender();
            fileHandler.setThreshold((Priority)level);
            fileHandler.setFile(filename);
            fileHandler.setLayout((Layout)layout);
            fileHandler.setMaxFileSize(maxSize);
            fileHandler.setMaxBackupIndex(maxBackupIndex.intValue());
            fileHandler.setName(handlerConfig.name().name());
            this.addFilters((Appender)fileHandler, handlerConfig.getFilters());
            fileHandler.activateOptions();
            logger.addAppender((Appender)fileHandler);
        }
        catch (Exception e) {
            throw new LoggingException("Exception occurs while adding file handler::" + e);
        }
    }

    private org.apache.log4j.Level convertLevel(String level) {
        if (Level.WARN.name().equals(level) || Level.WARNING.name().equals(level)) {
            return org.apache.log4j.Level.WARN;
        }
        if (Level.ERROR.name().equals(level)) {
            return org.apache.log4j.Level.ERROR;
        }
        if (Level.ALL.name().equals(level)) {
            return org.apache.log4j.Level.ALL;
        }
        if (Level.INFO.name().equals(level)) {
            return org.apache.log4j.Level.INFO;
        }
        if (Level.OFF.name().equals(level)) {
            return org.apache.log4j.Level.OFF;
        }
        return org.apache.log4j.Level.INFO;
    }

    @Override
    protected String formatPattern(String pattern) {
        if ((pattern = pattern.trim().replaceAll(" +", " ")).contains("%d") && !pattern.contains("%d{")) {
            pattern = pattern.replaceAll("%d", "%d{yyyy-MM-dd HH:mm:ss}");
        }
        pattern = pattern.replaceAll("%yyyy", "yyyy");
        pattern = pattern.replaceAll("%MMMM", "MMMM");
        pattern = pattern.replaceAll("%MMM", "MMM");
        pattern = pattern.replaceAll("%MM", "MM");
        pattern = pattern.replaceAll("%dd", "dd");
        pattern = pattern.replaceAll("%HH", "HH");
        pattern = pattern.replaceAll("%hh", "hh");
        pattern = pattern.replaceAll("%mm", "mm");
        pattern = pattern.replaceAll("%ss", "ss");
        pattern = pattern.replaceAll("%logger", "%c");
        pattern = pattern.replaceAll("%level", "%p");
        pattern = pattern.replaceAll("%msg", "%m");
        return pattern;
    }

    private void addFilters(Appender appender, ArrayList<LogFilter> filters) {
        try {
            for (LogFilter filterConfig : filters) {
                if (!FilterType.RegEx.equals((Object)filterConfig.getName())) continue;
                appender.addFilter(this.addLogFilter(filterConfig));
            }
        }
        catch (Exception e) {
            throw new LoggingException("Exception Occured while adding filter to ::" + this.getClass().getCanonicalName() + e);
        }
    }

    private Filter addLogFilter(final LogFilter config) {
        Filter filter = new Filter(){

            public int decide(LoggingEvent log) {
                if (config != null) {
                    if (FilterProperty.LOGGER_NAME.equals((Object)config.getApplyOn()) && log.getLoggerName().matches(config.getExpression())) {
                        return Log4jLogger.this.onMatch(config.getOnMatch());
                    }
                    if (FilterProperty.MESSAGE.equals((Object)config.getApplyOn()) && log.getMessage().toString().matches(config.getExpression())) {
                        return Log4jLogger.this.onMatch(config.getOnMatch());
                    }
                }
                return Log4jLogger.this.onMismatch(config.getOnMatch());
            }
        };
        return filter;
    }

    private int onMismatch(FilterReply onMatch) {
        return this.convertFilterReply(onMatch, true);
    }

    private int onMatch(FilterReply onMatch) {
        return this.convertFilterReply(onMatch, false);
    }

    private int convertFilterReply(FilterReply onMatch, boolean invert) {
        switch (onMatch) {
            case ACCEPT: {
                return invert ? -1 : 1;
            }
            case DENY: {
                return invert ? 1 : -1;
            }
        }
        return 0;
    }
}

