/*
 * Decompiled with CFR 0.152.
 */
package org.appops.logging.impl;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.List;
import org.appops.core.annotation.Config;
import org.appops.logging.destination.DestinationLogger;
import org.appops.logging.destination.DestinationLoggerStore;
import org.appops.logging.logger.Logger;
import org.appops.logging.logger.config.HandlerConfig;
import org.appops.logging.logger.config.LoggerConfig;
import org.appops.logging.logger.config.constant.LoggerType;

public class LogManager {
    private Logger rootLogger;
    private LoggerConfig configuration;
    private DestinationLoggerStore destinationLoggerStore;

    private void configure(LoggerConfig configuration) {
        if (configuration != null) {
            List<HandlerConfig> handlers = configuration.getHandlers();
            if (configuration.getDestinationLogger() != null) {
                DestinationLogger<?> destLogger = this.getDestinationLoggerStore().get(configuration.getDestinationLogger());
                destLogger.removeAllHandlers();
                destLogger.addHandlers(handlers);
            }
            if (configuration.getOverrideLoggers() != null) {
                for (LoggerType logger : this.getDestinationLoggerStore().getDestinationLoggers().keySet()) {
                    if (!configuration.getOverrideLoggers().contains((Object)logger) || configuration.getDestinationLogger().equals((Object)logger)) continue;
                    DestinationLogger<?> destLogger = this.getDestinationLoggerStore().getDestinationLoggers().get((Object)logger);
                    destLogger.removeAllHandlers();
                    destLogger.addHandlers(handlers);
                }
            }
        }
    }

    public Logger getLogger(String loggerName) {
        this.rootLogger.setLoggerName(loggerName);
        return this.rootLogger;
    }

    public Logger getRootLogger() {
        return this.rootLogger;
    }

    @Inject
    public void setRootLogger(@Named(value="APPOPS_ROOT_LOGGER") Logger rootLogger) {
        this.rootLogger = rootLogger;
    }

    public LoggerConfig getConfiguration() {
        return this.configuration;
    }

    @Inject
    public void init(@Config LoggerConfig configuration, DestinationLoggerStore destinationLoggerStore) {
        this.configuration = configuration;
        this.setDestinationLoggerStore(destinationLoggerStore);
        this.configure(configuration);
    }

    public DestinationLoggerStore getDestinationLoggerStore() {
        return this.destinationLoggerStore;
    }

    public void setDestinationLoggerStore(DestinationLoggerStore destinationLoggerStore) {
        this.destinationLoggerStore = destinationLoggerStore;
    }
}

