/*
 * Decompiled with CFR 0.152.
 */
package org.appops.logging.logger.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.appops.logging.logger.config.LogFilter;
import org.appops.logging.logger.config.constant.HandlerAttribute;
import org.appops.logging.logger.config.constant.HandlerType;
import org.appops.logging.meta.Level;

public class HandlerConfig {
    private Map<HandlerAttribute, Object> config = new HashMap<HandlerAttribute, Object>();
    private ArrayList<LogFilter> filters;

    public HandlerConfig() {
        this.disable();
    }

    public void addAttribute(HandlerAttribute key, Object value) {
        this.getConfig().put(key, value);
    }

    public Map<HandlerAttribute, Object> getConfig() {
        return this.config;
    }

    public void setConfig(Map<HandlerAttribute, Object> configMap) {
        this.config = configMap;
    }

    public HandlerConfig withName(HandlerType handlerType) {
        this.addAttribute(HandlerAttribute.NAME, (Object)handlerType);
        return this;
    }

    public HandlerConfig withPattern(String pattern) {
        this.addAttribute(HandlerAttribute.PATTERN, pattern);
        return this;
    }

    public HandlerConfig withLevel(Level level) {
        this.addAttribute(HandlerAttribute.LEVEL, (Object)level);
        return this;
    }

    public HandlerConfig withFileName(String filename) {
        this.addAttribute(HandlerAttribute.FILENAME, filename);
        return this;
    }

    public HandlerConfig withMaxSize(String size) {
        this.addAttribute(HandlerAttribute.MAXSIZE, size);
        return this;
    }

    public HandlerConfig withMaxBackupIndex(int maxBackupIndex) {
        this.addAttribute(HandlerAttribute.MAX_BACKUP_INDEX, maxBackupIndex);
        return this;
    }

    public HandlerConfig enable() {
        this.addAttribute(HandlerAttribute.ENABLED, true);
        return this;
    }

    public HandlerConfig disable() {
        this.addAttribute(HandlerAttribute.ENABLED, false);
        return this;
    }

    public HandlerType name() {
        return HandlerType.valueOf(this.getConfig().get((Object)HandlerAttribute.NAME).toString());
    }

    public boolean enabled() {
        return (Boolean)this.getConfig().get((Object)HandlerAttribute.ENABLED);
    }

    public ArrayList<LogFilter> getFilters() {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        return this.filters;
    }

    public void setFilters(ArrayList<LogFilter> filters) {
        this.filters = filters;
    }

    public void addFilter(LogFilter filter) {
        this.getFilters().add(filter);
    }
}

