/*
 * Decompiled with CFR 0.152.
 */
package org.appops.logging.meta;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.appops.core.constant.IterableConstant;
import org.appops.logging.meta.Level;

public class LogMeta {
    SimpleDateFormat formatter = new SimpleDateFormat("MMM dd,yyyy hh:mm:ss aa");
    private Map<String, Object> metaMap = new HashMap<String, Object>();
    public static final DefaultAttribute LEVEL = new DefaultAttribute("LEVEL");
    public static final DefaultAttribute MESSAGE = new DefaultAttribute("MESSAGE");
    public static final DefaultAttribute LOG_TYPE = new DefaultAttribute("LOG_TYPE");
    public static final DefaultAttribute DATETIME = new DefaultAttribute("DATETIME");
    public static final DefaultAttribute LOGGERNAME = new DefaultAttribute("LOGGERNAME");

    public LogMeta() {
        this.addAttribute((String)((Object)DATETIME.value()), this.formatter.format(new Date()));
    }

    public Object getAttributeValue(String key) {
        return this.metaMap.get(key);
    }

    public LogMeta addAttribute(String key, Object value) {
        this.metaMap.put(key, value);
        return this;
    }

    public LogMeta withLevel(Level level) {
        return this.addAttribute((String)((Object)LEVEL.value()), (Object)level);
    }

    public LogMeta withMessage(String msg) {
        return this.addAttribute((String)((Object)MESSAGE.value()), msg);
    }

    public Map<String, Object> getMetaMap() {
        return this.metaMap;
    }

    public void setMetaMap(Map<String, Object> metaMap) {
        this.metaMap = metaMap;
    }

    public String level() {
        return (String)this.getAttributeValue((String)((Object)LEVEL.value()));
    }

    public String message() {
        return String.valueOf(this.getAttributeValue((String)((Object)MESSAGE.value())));
    }

    public String datetime() {
        return (String)this.getAttributeValue((String)((Object)DATETIME.value()));
    }

    public static final class DefaultAttribute
    extends IterableConstant<String> {
        protected DefaultAttribute(String value) {
            super((Serializable)((Object)value));
        }
    }
}

