/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.logging.logger;

import org.appops.logging.meta.Level;
import org.appops.logging.meta.LogMeta;

/**
 * Appops logger base.
 *
 * @author deba
 * @version $Id: $Id
 */
public interface Logger {


  /**
   * Add level meta to logger.
   *
   * @param level Log level to be used while logging.
   * @return updated Logger instance.
   */
  public Logger withLevel(Level level);

  /**
   * Add message meta to logger.
   *
   * @param message Log message to be used while logging.
   * @return updated Logger instance.
   */
  public Logger withMessage(String message);

  /**
   * Add meta information such as level,reason etc to logger.
   *
   * @param meta Log meta information.
   * @return updated Logger instance.
   */
  public Logger withMeta(LogMeta meta);

  /**
   * Add meta information such as level,reason etc to logger.
   *
   * @param key Log meta attribute key.
   * @param value Log meta attribute value.
   * @return updated Logger instance.
   */
  public Logger withMeta(String key, Object value);

  /**
   * Performs log operation with meta information stored in logger, through other available methods
   * such as {@link #withLevel(Level)},{@link #withMeta(LogMeta)} etc.
   *
   * @return Boolean result, true if logging operation succeeded.
   */
  public boolean log();

  /**
   * <p>setLoggerName.</p>
   *
   * @param loggerName a {@link java.lang.String} object.
   * @return a {@link org.appops.logging.logger.Logger} object.
   */
  public Logger setLoggerName(String loggerName);

}
