/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.logging.logger.config;

import org.appops.logging.logger.config.constant.FilterProperty;
import org.appops.logging.logger.config.constant.FilterReply;
import org.appops.logging.logger.config.constant.FilterType;

/**
 * <p>LogFilter class.</p>
 *
 * @author deba
 * @version $Id: $Id
 */
public class LogFilter {
  private FilterType name;
  private FilterProperty applyOn;
  private String expression;
  private FilterReply onMatch;

  /**
   * <p>Getter for the field <code>expression</code>.</p>
   *
   * @return a {@link java.lang.String} object.
   */
  public String getExpression() {
    return expression;
  }

  /**
   * <p>Setter for the field <code>expression</code>.</p>
   *
   * @param expression a {@link java.lang.String} object.
   */
  public void setExpression(String expression) {
    this.expression = expression;
  }

  /**
   * <p>Getter for the field <code>onMatch</code>.</p>
   *
   * @return a {@link org.appops.logging.logger.config.constant.FilterReply} object.
   */
  public FilterReply getOnMatch() {
    return onMatch;
  }

  /**
   * <p>Setter for the field <code>onMatch</code>.</p>
   *
   * @param onMatch a {@link org.appops.logging.logger.config.constant.FilterReply} object.
   */
  public void setOnMatch(FilterReply onMatch) {
    this.onMatch = onMatch;
  }

  /**
   * <p>Getter for the field <code>applyOn</code>.</p>
   *
   * @return a {@link org.appops.logging.logger.config.constant.FilterProperty} object.
   */
  public FilterProperty getApplyOn() {
    return applyOn;
  }

  /**
   * <p>Setter for the field <code>applyOn</code>.</p>
   *
   * @param applyOn a {@link org.appops.logging.logger.config.constant.FilterProperty} object.
   */
  public void setApplyOn(FilterProperty applyOn) {
    this.applyOn = applyOn;
  }

  /**
   * <p>Getter for the field <code>name</code>.</p>
   *
   * @return a {@link org.appops.logging.logger.config.constant.FilterType} object.
   */
  public FilterType getName() {
    return name;
  }

  /**
   * <p>Setter for the field <code>name</code>.</p>
   *
   * @param name a {@link org.appops.logging.logger.config.constant.FilterType} object.
   */
  public void setName(FilterType name) {
    this.name = name;
  }

}
