/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.logging.destination;

import java.util.List;
import org.appops.logging.logger.config.HandlerConfig;
import org.appops.logging.logger.config.constant.LoggerType;
import org.appops.logging.meta.Level;

/**
 * <p>Abstract DestinationLogger class.</p>
 *
 * @author deba
 * @version $Id: $Id
 */
public abstract class DestinationLogger<T> {

  /**
   * <p>log.</p>
   *
   * @param level a {@link org.appops.logging.meta.Level} object.
   * @param message a {@link java.lang.String} object.
   * @return a boolean.
   */
  public abstract boolean log(Level level, String message);

  /**
   * <p>removeAllHandlers.</p>
   */
  public abstract void removeAllHandlers();

  /**
   * <p>addHandlers.</p>
   *
   * @param handlers a {@link java.util.List} object.
   */
  public abstract void addHandlers(List<HandlerConfig> handlers);

  /**
   * <p>addHandler.</p>
   *
   * @param handler a {@link org.appops.logging.logger.config.HandlerConfig} object.
   */
  public abstract void addHandler(HandlerConfig handler);

  /**
   * <p>internalLogger.</p>
   *
   * @return a T object.
   */
  protected abstract T internalLogger();

  /**
   * <p>type.</p>
   *
   * @return a {@link org.appops.logging.logger.config.constant.LoggerType} object.
   */
  public abstract LoggerType type();

  /**
   * <p>formatPattern.</p>
   *
   * @param pattern a {@link java.lang.String} object.
   * @return a {@link java.lang.String} object.
   */
  protected abstract String formatPattern(String pattern);

}
