/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.logging.logger.formatter;

import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

/**
 * Formatter class which formats the log message for Java Util logger.
 *
 * @author deba
 * @version $Id: $Id
 */
public class JavaUtilLogFormatter extends Formatter {

  private String defaultFormatPattern = "%1$tF %1$tT %2$s %4$s %5$s%n";

  /** {@inheritDoc} */
  @Override
  public String format(LogRecord lr) {
    return String.format(defaultFormatPattern, new Date(lr.getMillis()), lr.getSourceClassName(),
        lr.getLoggerName(), lr.getLevel().getLocalizedName(), lr.getMessage(), lr.getThrown());
  }

  /**
   * <p>getFormat.</p>
   *
   * @return a {@link java.lang.String} object.
   */
  public String getFormat() {
    return defaultFormatPattern;
  }

  /**
   * <p>setFormat.</p>
   *
   * @param format a {@link java.lang.String} object.
   */
  public void setFormat(String format) {
    this.defaultFormatPattern = format;
  }

}
