/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.maven.plugin.helper;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.project.MavenProject;


/**
 * Helper class for mojo's.
 * 
 * @author vinay@ainosoft.com
 *
 */
public class MojoHelper {

  Logger logger = Logger.getLogger(this.getClass().getSimpleName());

  /**
   * Provides the Url class loader of the maven project provided to it.
   * 
   * @param project Host maven project.
   * @return Custom configured class loader.
   */
  public URLClassLoader getClassLoader(MavenProject project) {
    URLClassLoader urlClassLoader = null;
    try {

      Set<String> classpathElements = new HashSet<>();
      List<String> compileClasspathElements = project.getCompileClasspathElements();

      List<URL> urlList = new ArrayList<URL>();
      classpathElements.addAll(compileClasspathElements);
      classpathElements.add(project.getBuild().getOutputDirectory());
      for (String classPathElement : classpathElements) {

        urlList.add(new File((String) classPathElement).toURI().toURL());
      }
      urlClassLoader = new URLClassLoader(urlList.toArray(new URL[urlList.size()]),
          this.getClass().getClassLoader());
    } catch (Exception e) {

      logger.log(Level.SEVERE, "Exception in " + this.getClass().getSimpleName() + " : " + e);
    }

    return urlClassLoader;
  }

  /**
   * Provides absolute java package name.
   * 
   * @param absolutePath Path of java resource.
   * @param project Host maven project.
   * 
   * @return Qualified java package name.
   */
  public String getPackageName(String absolutePath, MavenProject project) {
    String[] pathArr = absolutePath.split(File.separator + project.getArtifactId() + File.separator
        + "target" + File.separator + "classes" + File.separator);
    String packageName = pathArr[pathArr.length - 1];
    String packageTemp = packageName.replace(File.separator, ".");
    String finalPackageName = packageTemp.replace(".class", "");
    return finalPackageName;
  }
}
