/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.maven.plugin.mojo;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLClassLoader;
import java.util.List;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.appops.marshaller.DescriptorType;
import org.appops.maven.plugin.helper.MojoHelper;
import org.appops.service.deployment.ContainerType;



@Mojo(name = "deploy-cl", requiresDependencyResolution = ResolutionScope.COMPILE_PLUS_RUNTIME)
public class ServiceClubbedDepMojo extends AbstractMojo {

  @Parameter(required = true)
  private ContainerType containerType;

  @Parameter(required = true)
  private String deploymentConfig;

  @Parameter(defaultValue = "${project}")
  private MavenProject project;

  @Parameter(required = true)
  private String copyTo;

  @Parameter(required = true)
  private String serviceName;


  @Override
  public void execute() throws MojoExecutionException, MojoFailureException {
    try {

      URLClassLoader classLoader = new MojoHelper().getClassLoader(project);
      Thread.currentThread().setContextClassLoader(classLoader);
      classLoader.loadClass("org.appops.service.impl.guice.ServiceStoreModule");

      String destPath = copyTo + "/" + serviceName;
      File destFileDirectory = new File(destPath);
      if (!destFileDirectory.exists()) {
        destFileDirectory.mkdir();
      }

      List<Resource> resources = project.getResources();
      for (Resource resource : resources) {

        File resourceDirectoryPath = new File(resource.getDirectory());
        File[] filesList = resourceDirectoryPath.listFiles();
        for (File sourcefile : filesList) {

          if (sourcefile.getName().equals("app") || sourcefile.getName().equals("dep-prod.yml")) {

            String newDestDirctPath = destFileDirectory.getPath() + "/app";
            File newDestFileDirectory = new File(newDestDirctPath);
            if (!newDestFileDirectory.exists()) {

              newDestFileDirectory.mkdir();
            }

            if (sourcefile.isDirectory()) {

              try {

                copyDirectory(sourcefile, newDestFileDirectory);
              } catch (Exception e) {

                e.printStackTrace();
              }

            } else {
              String destFilePath = newDestFileDirectory.getPath() + "/" + sourcefile.getName();
              File destFile = new File(destFilePath);
              DescriptorType descriptorType = DescriptorType.fromExtension(destFile.getName());
              String relativePath = destFile.getCanonicalPath().replace(destFile.getName(),
                  "deployment-backup" + "." + descriptorType.getValue());
              destFile.renameTo(new File(relativePath));
              copyFile(sourcefile, destFile);
            }
          }

          if (sourcefile.getName().equals("Dockerfile")) {

            String destFilePath = destFileDirectory.getPath() + "/" + sourcefile.getName();
            File destFile = new File(destFilePath);
            copyFile(sourcefile, destFile);
          }
        }
      }

    } catch (Exception e) {

      e.printStackTrace();
    }

  }

  /**
   * Copy directory from specified source and destination.
   * 
   * @param sourceDirectory sourcedir file object.
   * @param destinationDirectory destination directory object.
   * @throws IOException throws exception if occurs between process
   */
  private void copyDirectory(File sourceDirectory, File destinationDirectory) throws IOException {
    if (!destinationDirectory.exists()) {

      destinationDirectory.mkdir();
    }
    for (String f : sourceDirectory.list()) {

      copyDirectoryCompatibityMode(new File(sourceDirectory, f), new File(destinationDirectory, f));
    }
  }

  /**
   * Checks the file is directory.
   * 
   * @param source src file object
   * @param destination dest file object
   * @throws IOException throws exception if occurs between process
   */
  public void copyDirectoryCompatibityMode(File source, File destination) throws IOException {
    if (source.isDirectory()) {

      copyDirectory(source, destination);
    } else {

      copyFile(source, destination);
    }
  }

  /**
   * Copy file from specified source and destination.
   * 
   * @param sourceFile src file object.
   * @param destinationFile dest file object
   * @throws IOException throws exception if occurs between process
   */
  private static void copyFile(File sourceFile, File destinationFile) throws IOException {
    try (InputStream in = new FileInputStream(sourceFile);
        OutputStream out = new FileOutputStream(destinationFile)) {

      byte[] buf = new byte[1024];
      int length;
      while ((length = in.read(buf)) > 0) {

        out.write(buf, 0, length);
      }
    }
  }

  public ContainerType getContainerType() {
    return containerType;
  }

  public void setContainerType(ContainerType containerType) {
    this.containerType = containerType;
  }

  public MavenProject getProject() {
    return project;
  }

  public void setProject(MavenProject project) {
    this.project = project;
  }


}
