/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.maven.plugin.mojo;

import java.lang.reflect.Method;
import java.net.URLClassLoader;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.appops.maven.plugin.helper.MojoHelper;

@Mojo(name = "run-service", requiresDependencyResolution = ResolutionScope.RUNTIME)
public class RunServiceEntryPointMojo extends AbstractMojo {


  @Parameter(defaultValue = "${project}", required = true)
  private MavenProject project;

  @Parameter(required = true)
  private String mainClass;

  @Override
  public void execute() throws MojoExecutionException, MojoFailureException {
    URLClassLoader classLoader = new MojoHelper().getClassLoader(project);
    Thread.currentThread().setContextClassLoader(classLoader);
    try {
      Class<?> main = classLoader.loadClass(mainClass);
      Method[] methods = main.getDeclaredMethods();
      String[] args = {};
      for (Method method : methods) {
        method.invoke(main, new Object[] {args});
        System.out.println();
        System.out.println("==========  Service Entry Point Is Running  ==========");
        System.out.println("Hit Your Service BaseUrl In Browser (example : http://localhost:8080)");
        Thread.currentThread().join();
      }
    } catch (Exception e) {
      e.printStackTrace();
    }
  }

  public MavenProject getProject() {
    return project;
  }

  public void setProject(MavenProject project) {
    this.project = project;
  }

  public String getMainClass() {
    return mainClass;
  }

  public void setMainClass(String mainClass) {
    this.mainClass = mainClass;
  }

}
