/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.scheduler.injection;

import com.google.inject.Singleton;
import org.appops.core.annotation.ImplModule;
import org.appops.job.JobPipelineProcessor;
import org.appops.job.JobPipelineQueue;
import org.appops.job.JobSchedulerThread;
import org.appops.job.JobStageConverter;
import org.appops.job.JobTokenQueue;
import org.appops.job.TokenProcessor;
import org.appops.job.TokenScheduler;
import org.appops.job.core.Scheduler;
import org.appops.scheduler.converter.JobStageConverterImpl;
import org.appops.scheduler.executor.JobPipelineExecutor;
import org.appops.scheduler.executor.JobPipelineExecutorImpl;
import org.appops.scheduler.queue.JobPipelineQueueImpl;
import org.appops.scheduler.queue.JobTokenQueueImpl;
import org.appops.scheduler.service.JobPipelineProcessorImpl;
import org.appops.scheduler.service.TokenProcessorImpl;
import org.appops.scheduler.service.TokenSchedulerImpl;
import org.appops.scheduler.thread.JobSchedulerThreadImpl;
import org.appops.service.injection.ServiceModule;


/**
 * <p>
 * SchedulerModule class.
 * </p>
 *
 * @author deba
 * @version $Id: $Id
 */
@ImplModule(serviceName = Scheduler.class)
public class SchedulerModule extends ServiceModule {

  /** {@inheritDoc} */
  @Override
  public void configureModule() {
    bind(JobTokenQueue.class).to(JobTokenQueueImpl.class).in(Singleton.class);
    bind(TokenScheduler.class).to(TokenSchedulerImpl.class);
    bind(TokenProcessor.class).to(TokenProcessorImpl.class);
    bind(JobSchedulerThread.class).to(JobSchedulerThreadImpl.class).in(Singleton.class);
    bind(JobPipelineQueue.class).to(JobPipelineQueueImpl.class).in(Singleton.class);
    bind(JobPipelineProcessor.class).to(JobPipelineProcessorImpl.class);
    bind(JobStageConverter.class).to(JobStageConverterImpl.class);
    bind(JobPipelineExecutor.class).to(JobPipelineExecutorImpl.class);
  }

}
