/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.scheduler.queue;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.appops.job.JobPipeline;
import org.appops.job.JobPipelineQueue;
import org.appops.job.JobStage;

/**
 * An implmentation of {@link org.appops.job.JobPipelineQueue} which provides Job pipeline related
 * functionality.
 *
 * @author deba
 * @version $Id: $Id
 */
public class JobPipelineQueueImpl implements JobPipelineQueue {

  private Map<String, JobPipeline> jobPipelineQueue = new LinkedHashMap<String, JobPipeline>();
  private Map<String, LinkedList<JobStage>> jobStageQueue =
      new HashMap<String, LinkedList<JobStage>>();
  private Map<String, JobPipeline> jobPipelineProgressedQueue =
      new LinkedHashMap<String, JobPipeline>();


  /**
   * {@inheritDoc}
   *
   * Add given job pipeline into job pipeline queue.
   */
  @Override
  public void addJobPipeline(JobPipeline jobPipeline) {
    jobPipelineQueue.put(jobPipeline.getGuid(), jobPipeline);
  }

  /**
   * {@inheritDoc}
   *
   * Get total size of job pipeline queue.
   */
  @Override
  public Integer size() {
    return this.jobPipelineQueue.size();
  }

  /**
   * {@inheritDoc}
   *
   * It pops the {@link JobPipeline} from job pipeline queue and return it.
   */
  @Override
  public JobPipeline popJobPipeline() {
    if (jobPipelineQueue.isEmpty()) {
      return null;
    }

    Map.Entry<String, JobPipeline> jobPipelineEntry = jobPipelineQueue.entrySet().iterator().next();
    String key = jobPipelineEntry.getKey();
    JobPipeline jobPipeline = jobPipelineEntry.getValue();
    jobPipelineQueue.remove(key);
    jobPipelineProgressedQueue.put(key, jobPipeline);
    return jobPipeline;
  }

  /**
   * {@inheritDoc}
   *
   * Add {@link JobStage} list into job stage queue against given unique job stage queue.
   */
  @Override
  public void addJobStages(String jobPipelineKey, LinkedList<JobStage> jobStageList) {
    this.jobStageQueue.put(jobPipelineKey, jobStageList);
  }

  /**
   * {@inheritDoc}
   *
   * It returns next job stage from job stage queue.
   */
  @Override
  public JobStage getNextPipelineJobStage(String guid) {
    if (!jobStageQueue.isEmpty()) {
      JobStage jobStage = jobStageQueue.get(guid).pollFirst();
      if (jobStage == null) {
        jobStageQueue.remove(guid);
      }
      return jobStage;
    }
    return null;
  }

  /** {@inheritDoc} */
  @Override
  public JobPipeline getJobPipelineFromGuid(String guid) {
    if (guid != null) {
      return jobPipelineProgressedQueue.get(guid);
    }
    return null;
  }


}
