/*
 * Decompiled with CFR 0.152.
 */
package org.appops.scheduler.executor;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.Serializable;
import org.appops.core.ClassPathAnalyser;
import org.appops.core.job.token.JobToken;
import org.appops.core.job.token.JobTokenInputInfo;
import org.appops.job.JobPipeline;
import org.appops.job.JobPipelineIoConverter;
import org.appops.job.JobPipelineQueue;
import org.appops.job.JobStage;
import org.appops.job.JobStageConverter;
import org.appops.logging.impl.LogManager;
import org.appops.logging.logger.Logger;
import org.appops.logging.meta.Level;
import org.appops.marshaller.DescriptorType;
import org.appops.marshaller.Marshaller;
import org.appops.scheduler.executor.DerivedIoConverterFactory;
import org.appops.scheduler.executor.JobPipelineExecutor;
import org.appops.service.event.JobEvent;
import org.appops.service.job.TokenRouter;
import org.appops.slim.base.api.ServiceMetaManager;
import org.quartz.SchedulerException;

public class JobPipelineExecutorImpl
implements JobPipelineExecutor {
    @Inject
    private Provider<TokenRouter> tokenRouterProvider;
    private JobPipelineQueue jobPipelineQueue;
    private ClassPathAnalyser classPathAnalyser;
    private Logger logger;
    @Inject
    private Provider<JobStageConverter> jobStageConverter;
    @Inject
    DerivedIoConverterFactory derivedIoConverterFactory;
    @Inject
    private Marshaller marshaller;
    private Provider<ServiceMetaManager> serviceMetaManager;

    public JobPipelineExecutorImpl() {
    }

    @Inject
    public JobPipelineExecutorImpl(LogManager logManager) {
        this.logger = logManager.getRootLogger();
    }

    @Override
    public void executeNextJobToken(JobEvent event) {
        if ("STARTED".equals(event.getEventStatus())) {
            JobToken startedJobToken = this.convertJobTokenJson(event.jobToken());
            this.jobStartedEvent(startedJobToken);
        } else if ("COMPLETED".equals(event.getJobEventStatus())) {
            try {
                JobStage jobToken = this.executeNextJob(event);
                if (jobToken == null) {
                    JobToken completedJobToken = this.convertJobTokenJson(event.jobToken());
                    this.jobCompletedEvent(completedJobToken);
                }
            }
            catch (Exception e) {
                this.logger.withMessage("Exception occurred while executing next job token in executeNextJobToken()::" + e);
            }
        }
    }

    private JobToken convertJobTokenJson(Object jobTokenData) {
        String jobTokenJson = this.marshaller.marshall(jobTokenData, DescriptorType.JSON);
        return (JobToken)this.marshaller.unmarshall(jobTokenJson, JobToken.class, DescriptorType.JSON);
    }

    private JobStage executeNextJob(JobEvent jobEvent) throws SchedulerException {
        JobToken previousToken = this.convertJobTokenJson(jobEvent.jobToken());
        String guid = previousToken.getGuid();
        JobStage jobStage = this.jobPipelineQueue.getNextPipelineJobStage(guid);
        if (jobStage != null) {
            JobPipeline jobPipeline = this.jobPipelineQueue.getJobPipelineFromGuid(guid);
            if (jobPipeline != null) {
                String serviceName = jobPipeline.getIoConverterServiceName();
                String interfaceName = jobPipeline.getIoConverterInterfaceName();
                JobPipelineIoConverter baseIoConverter = (JobPipelineIoConverter)this.derivedIoConverterFactory.getDerviedInstanceOfConverter(JobPipelineIoConverter.class, serviceName, interfaceName);
                Object jobResult = jobEvent.jobResult();
                String jobResultJson = this.marshaller.marshall(jobResult, DescriptorType.JSON);
                JobToken converterJobToken = ((JobStageConverter)this.jobStageConverter.get()).convertJobStageToJobToken(jobStage);
                JobTokenInputInfo jobTokenInputInfo = converterJobToken.getJobTokenInputInfo();
                if (jobTokenInputInfo != null) {
                    String ioResultJson = baseIoConverter.convertIoFromTo(jobResultJson, jobTokenInputInfo.getInputParameterClassName());
                    converterJobToken.addParameter(jobTokenInputInfo.getInputParameterName(), (Serializable)((Object)ioResultJson));
                }
                ((TokenRouter)this.tokenRouterProvider.get()).routeJobToken(converterJobToken);
            } else {
                this.logger.withMessage("JobPipeline getting null.");
            }
        } else {
            this.logger.withMessage("No JobStages in job stage queue.");
        }
        return jobStage;
    }

    private void jobCompletedEvent(JobToken token) {
        this.logger.withLevel(Level.INFO).withMessage("Job Execution Completed :" + token.getJobKey());
    }

    private void jobStartedEvent(JobToken token) {
        this.logger.withLevel(Level.INFO).withMessage("Job Execution started :" + token.getJobKey());
    }

    public ClassPathAnalyser getClassPathAnalyser() {
        return this.classPathAnalyser;
    }

    @Inject
    public void setClassPathAnalyser(ClassPathAnalyser classPathAnalyser) {
        this.classPathAnalyser = classPathAnalyser;
    }

    public JobPipelineQueue getJobPipelineQueue() {
        return this.jobPipelineQueue;
    }

    @Inject
    public void setJobPipelineQueue(JobPipelineQueue jobPipelineQueue) {
        this.jobPipelineQueue = jobPipelineQueue;
    }

    public Provider<ServiceMetaManager> getServiceMetaManager() {
        return this.serviceMetaManager;
    }

    @Inject
    public void setServiceMetaManager(Provider<ServiceMetaManager> serviceMetaManager) {
        this.serviceMetaManager = serviceMetaManager;
    }
}

