/*
 * Decompiled with CFR 0.152.
 */
package org.appops.scheduler.service;

import com.google.inject.Inject;
import org.appops.core.job.token.JobToken;
import org.appops.core.job.token.TokenType;
import org.appops.job.JobTokenQueue;
import org.appops.job.TokenScheduler;
import org.appops.scheduler.exception.SchedulerException;
import org.quartz.CronExpression;

public class TokenSchedulerImpl
implements TokenScheduler {
    private JobTokenQueue tokenQueue;

    @Inject
    public TokenSchedulerImpl(JobTokenQueue queue) {
        this.tokenQueue = queue;
    }

    public void scheduleToken(JobToken token) {
        this.validateToken(token);
        this.tokenQueue.addToken(token);
    }

    private void validateToken(JobToken token) {
        String scheduleExpression;
        if (token == null) {
            throw new SchedulerException("Unabled to add token into queue, Token cannot be null.");
        }
        if (TokenType.SCHEDULE.equals((Object)token.getTokenType()) && ((scheduleExpression = token.getScheduleExpression()) == null || !CronExpression.isValidExpression((String)scheduleExpression))) {
            throw new SchedulerException("Unabled to add token into queue, schedule expression is invalid.");
        }
        if (token.getJobKey() == null || token.getJobKey().isEmpty()) {
            throw new SchedulerException("Unabled to add token into queue, job key cannot be null or empty.");
        }
    }
}

