/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.scheduler.app;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.lang.annotation.Annotation;
import org.appops.core.deployment.ServiceConfiguration;
import org.appops.entitystore.core.Schema;
import org.appops.entitystore.hibernate.SchemaDefinitionGenerator;
import org.appops.entitystore.hibernate.SessionFactoryStore;
import org.appops.entitystore.hibernate.configuration.SessionFactoryGenerator;
import org.appops.job.JobPipelineQueue;
import org.appops.job.core.Scheduler;
import org.appops.service.ServiceInitializer;
import org.appops.service.generator.ServiceMetaGenerator;
import org.appops.slim.base.api.ServiceMetaManager;
import org.hibernate.SessionFactory;

/**
 * <p>
 * SchedulerInitializer class.
 * </p>
 *
 * @author deba
 * @version $Id: $Id
 */
@Scheduler
public class SchedulerInitializer extends ServiceInitializer {
  private Provider<SchemaDefinitionGenerator> schemaDefGenerator;
  private Provider<SessionFactoryGenerator> sessionFactoryGenerator;
  private SessionFactoryStore sessionFactoryStore;
  @Inject
  private JobPipelineQueue jobPipelineQueue;


  /**
   * <p>
   * Constructor for LabeloxInitializer.
   * </p>
   *
   * @param serviceMetaGenerator a {@link com.google.inject.Provider} object.
   * @param serviceMetaManager a {@link com.google.inject.Provider} object.
   */
  @Inject
  public SchedulerInitializer(Provider<ServiceMetaGenerator> serviceMetaGenerator,
      Provider<ServiceMetaManager> serviceMetaManager) {
    super(serviceMetaGenerator, serviceMetaManager);

  }

  @Override
  public String initialize(String serviceName, ServiceConfiguration config,
      Class<? extends Annotation> serviceAnnotation) {
    addServiceMeta(serviceName, config, serviceAnnotation);
    registerSchemaDefinition(serviceAnnotation);
    jobPipelineQueue.addJobPipelinesToQueue();
    return serviceName;

  }

  /**
   * Generates and registers service schema definition.
   */
  private void registerSchemaDefinition(Class<? extends Annotation> serviceAnnotation) {
    Schema schema = schemaDefGenerator.get().generatateSchemaDefinition(serviceAnnotation);
    SessionFactory sessionFactory = sessionFactoryGenerator.get().generateSessionFactory(schema);
    sessionFactoryStore.addSessionFactory(schema.getName(), sessionFactory);
  }

  public Provider<SchemaDefinitionGenerator> getSchemaDefGenerator() {
    return schemaDefGenerator;
  }

  public Provider<SessionFactoryGenerator> getSessionFactoryGenerator() {
    return sessionFactoryGenerator;
  }

  public SessionFactoryStore getSessionFactoryStore() {
    return sessionFactoryStore;
  }

  @Inject
  public void setSchemaDefGenerator(Provider<SchemaDefinitionGenerator> schemaDefGenerator) {
    this.schemaDefGenerator = schemaDefGenerator;
  }

  @Inject
  public void setSessionFactoryGenerator(
      Provider<SessionFactoryGenerator> sessionFactoryGenerator) {
    this.sessionFactoryGenerator = sessionFactoryGenerator;
  }

  @Inject
  public void setSessionFactoryStore(SessionFactoryStore sessionFactoryStore) {
    this.sessionFactoryStore = sessionFactoryStore;
  }
}
