/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */
package org.appops.scheduler.dao;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.sql.Blob;
import java.util.List;
import org.appops.entitystore.hibernate.dao.SingleEntityDaoBase;
import org.appops.job.core.Scheduler;
import org.appops.scheduler.pojo.JobPipelinePojo;
import org.hibernate.Hibernate;
import org.hibernate.Session;

public class JobPipelineDao extends SingleEntityDaoBase {

  /**
   * <p>
   * Constructor for JobPipelineDao.
   * </p>
   *
   * @param sessionProvider a {@link com.google.inject.Provider} object.
   */
  @Inject
  public JobPipelineDao(@Scheduler Provider<Session> sessionProvider) {
    super(sessionProvider);
  }

  /**
   * It saves the job pipeline.
   * 
   * @param jobPipelinepojo instance of {@link JobPipelinePojo}
   */
  public void saveJobPipeline(JobPipelinePojo jobPipelinepojo) {

    Blob blob = Hibernate.getLobCreator(getPojoSession()).createBlob(null);

    savePojo(jobPipelinepojo);

  }

  /**
   * It returns list of existing job pipelines.
   * 
   * @param scheduleAt schedule expression
   * @return list of job pipeline pojos
   */
  public List<JobPipelinePojo> getExistingJobPipelines(String scheduleAt) {
    String queryString = " from " + JobPipelinePojo.class.getCanonicalName()
        + " where sch_expression= " + scheduleAt;
    return getResultList(queryString);
  }

  public List<JobPipelinePojo> getAllJobPipelines() {
    String queryString = " from " + JobPipelinePojo.class.getCanonicalName();
    return getResultList(queryString);
  }


}
