/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */
package org.appops.scheduler.injection;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.servlet.GuiceServletContextListener;
import java.util.ArrayList;
import java.util.List;
import org.appops.configuration.guice.ConfigServiceModule;
import org.appops.entitystore.injection.EntityStoreModule;
import org.appops.logging.guice.DefaultLoggerModule;
import org.appops.marshaller.guice.MarshallerModule;
import org.appops.service.injection.ServiceBaseModule;
import org.appops.service.injection.ServiceStoreSlimModule;
import org.appops.web.jetty.JettyWebServiceModule;

public class SchedulerInjectorProvider extends GuiceServletContextListener {
  private static Injector injector;

  @Override
  public Injector getInjector() {
    if (injector == null) {
      List<Module> modules = new ArrayList<>();
      modules.add(new EntityStoreModule());
      modules.add(new ServiceBaseModule());
      modules.add(new DefaultLoggerModule());
      modules.add(new ConfigServiceModule());
      modules.add(new MarshallerModule());
      modules.add(new JettyWebServiceModule());
      modules.add(new ServiceStoreSlimModule());
      modules.add(new SchedulerModule());
      injector = Guice.createInjector(modules);
    }
    return injector;
  }
}
