/*
 * Decompiled with CFR 0.152.
 */
package org.appops.scheduler.queue;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.appops.job.JobPipeline;
import org.appops.job.JobPipelineQueue;
import org.appops.job.JobStage;
import org.appops.marshaller.Marshaller;
import org.appops.scheduler.helper.JobPipelineHelper;

public class JobPipelineQueueImpl
implements JobPipelineQueue {
    private Map<String, JobPipeline> jobPipelineQueue = new LinkedHashMap<String, JobPipeline>();
    private Map<String, LinkedList<JobStage>> jobStageQueue = new HashMap<String, LinkedList<JobStage>>();
    private Map<String, JobPipeline> jobPipelineProgressedQueue = new LinkedHashMap<String, JobPipeline>();
    private Map<String, JobPipeline> pipelinesQueue = new LinkedHashMap<String, JobPipeline>();
    @Inject
    private JobPipelineHelper jobPipelineHelper;
    @Inject
    private Marshaller marshaller;

    public void addJobPipeline(JobPipeline jobPipeline) {
        if (!jobPipeline.getScheduleExpression().isEmpty()) {
            JobPipeline jobPipeline2 = this.jobPipelineHelper.saveJobPipeline(jobPipeline);
        }
        if (jobPipeline != null) {
            this.jobPipelineQueue.put(jobPipeline.getGuid(), jobPipeline);
        }
    }

    public Integer size() {
        return this.jobPipelineQueue.size();
    }

    public JobPipeline popJobPipeline() {
        if (this.jobPipelineQueue.isEmpty()) {
            return null;
        }
        Map.Entry<String, JobPipeline> jobPipelineEntry = this.jobPipelineQueue.entrySet().iterator().next();
        String key = jobPipelineEntry.getKey();
        JobPipeline jobPipeline = jobPipelineEntry.getValue();
        this.jobPipelineQueue.remove(key);
        this.jobPipelineProgressedQueue.put(key, jobPipeline);
        return jobPipeline;
    }

    public List<JobPipeline> getAllJobPipelines() {
        return this.jobPipelineHelper.getAllJobPipelines();
    }

    public List<JobPipeline> getAllJobPipelinesFromQueue() {
        ArrayList<JobPipeline> jobPipelineList = new ArrayList<JobPipeline>();
        Map.Entry<String, JobPipeline> jobPipelineEntry = this.jobPipelineQueue.entrySet().iterator().next();
        String key = jobPipelineEntry.getKey();
        JobPipeline jobPipeline = jobPipelineEntry.getValue();
        jobPipelineList.add(jobPipeline);
        return jobPipelineList;
    }

    private String getCurrentTimeExprssion() {
        Calendar now = Calendar.getInstance();
        String scheduleAt = now.get(13) + " " + now.get(12) + " " + now.get(11) + " * * ?";
        return scheduleAt;
    }

    public void addJobPipelinesToQueue() {
        List<JobPipeline> jobPipelineList = this.jobPipelineHelper.getAllJobPipelines();
        for (JobPipeline jobPipeline : jobPipelineList) {
            this.jobPipelineQueue.put(jobPipeline.getGuid(), jobPipeline);
        }
    }

    public void addJobStages(String jobPipelineKey, LinkedList<JobStage> jobStageList) {
        this.jobStageQueue.put(jobPipelineKey, jobStageList);
    }

    public JobStage getNextPipelineJobStage(String guid) {
        if (!this.jobStageQueue.isEmpty()) {
            JobStage jobStage = this.jobStageQueue.get(guid).pollFirst();
            if (jobStage == null) {
                this.jobStageQueue.remove(guid);
            }
            return jobStage;
        }
        return null;
    }

    public JobPipeline getJobPipelineFromGuid(String guid) {
        if (guid != null) {
            return this.jobPipelineProgressedQueue.get(guid);
        }
        return null;
    }
}

