/*
 * Decompiled with CFR 0.152.
 */
package org.appops.scheduler.queue;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.appops.core.job.token.JobToken;
import org.appops.core.job.token.TokenType;
import org.appops.job.JobTokenQueue;
import org.appops.scheduler.exception.SchedulerException;
import org.quartz.CronExpression;

public class JobTokenQueueImpl
implements JobTokenQueue {
    private List<JobToken> tokenQueue = Collections.synchronizedList(new LinkedList());
    private SortedMap<Date, ArrayList<JobToken>> scheduleQueue = Collections.synchronizedSortedMap(new TreeMap());

    public Set<JobToken> popTokens() {
        HashSet<JobToken> selectedTokens = new HashSet<JobToken>();
        selectedTokens.addAll(this.getElapsedSchedules());
        JobToken jobToken = this.getNextJobToken();
        if (jobToken != null) {
            selectedTokens.add(jobToken);
        }
        return selectedTokens;
    }

    public void addToken(JobToken token) {
        try {
            if (TokenType.SCHEDULE.equals((Object)token.getTokenType())) {
                this.addScheduleToken(token);
            } else {
                this.tokenQueue.add(token);
            }
        }
        catch (Exception e) {
            throw new SchedulerException("Unabled to add token to queue", e);
        }
    }

    private void addScheduleToken(JobToken token) {
        try {
            Date schedule = this.getNextValidTimeFor(token.getScheduleExpression());
            this.getScheduledTokens(schedule).add(token);
        }
        catch (Exception e) {
            throw new SchedulerException("Unabled to add token to queue", e);
        }
    }

    public JobToken getNextJobToken() {
        if (this.tokenQueue.isEmpty()) {
            return null;
        }
        JobToken token = this.tokenQueue.get(0);
        this.tokenQueue.remove(token);
        return token;
    }

    public Set<JobToken> getElapsedSchedules() {
        Date currentTime = new Date();
        HashSet<JobToken> selectedSchedules = new HashSet<JobToken>();
        while (new TreeMap<Date, ArrayList<JobToken>>(this.scheduleQueue).lowerKey(currentTime) != null) {
            Date elapsedKey = new TreeMap<Date, ArrayList<JobToken>>(this.scheduleQueue).lowerKey(currentTime);
            ArrayList elapsedSchedules = (ArrayList)this.scheduleQueue.get(elapsedKey);
            selectedSchedules.addAll(elapsedSchedules);
            elapsedSchedules.removeAll(selectedSchedules);
            if (!elapsedSchedules.isEmpty()) continue;
            this.scheduleQueue.remove(elapsedKey);
        }
        return selectedSchedules;
    }

    protected Date getNextValidTimeFor(String scheduleExpression) throws ParseException {
        CronExpression cronExpression = new CronExpression(scheduleExpression);
        return cronExpression.getNextValidTimeAfter(new Date());
    }

    private ArrayList<JobToken> getScheduledTokens(Date schedule) {
        if (!this.scheduleQueue.containsKey(schedule) || this.scheduleQueue.get(schedule) == null) {
            this.scheduleQueue.put(schedule, new ArrayList());
        }
        return (ArrayList)this.scheduleQueue.get(schedule);
    }

    public Boolean removeJobTokens(List<JobToken> tokens) {
        return this.tokenQueue.removeAll(tokens);
    }

    public Map<Date, ArrayList<JobToken>> getScheduleTokens() {
        HashMap<Date, ArrayList<JobToken>> map = new HashMap<Date, ArrayList<JobToken>>();
        map.putAll(this.scheduleQueue);
        return map;
    }

    public Boolean isTokenPresent(JobToken token) {
        return this.tokenQueue.contains(token) || TokenType.SCHEDULE.equals((Object)token.getTokenType()) && this.isScheduledTokenPresent(token) != false;
    }

    private Boolean isScheduledTokenPresent(JobToken token) {
        for (Collection collection : this.scheduleQueue.values()) {
            if (!collection.contains(token)) continue;
            return true;
        }
        return false;
    }

    public Integer size() {
        int size = this.tokenQueue.size();
        for (Collection collection : this.scheduleQueue.values()) {
            size += collection.size();
        }
        return size;
    }
}

