/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.scheduler.service;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.appops.core.job.token.JobToken;
import org.appops.core.service.annotation.ServiceOp;
import org.appops.job.JobPipeline;
import org.appops.job.JobPipelineProcessor;
import org.appops.job.JobPipelineQueue;
import org.appops.job.JobStage;
import org.appops.job.JobStageConverter;
import org.appops.job.JobTokenQueue;

/**
 * A processor class which processed the {@link org.appops.job.JobPipeline}.
 *
 * @author deba
 * @version $Id: $Id
 */
public class JobPipelineProcessorImpl implements JobPipelineProcessor {

  private Provider<JobPipelineQueue> jobPipelineQueue;
  private Provider<JobStageConverter> jobStageConverter;
  private Provider<JobTokenQueue> jobTokenQueue;

  /**
   * Parameterized constructor of {@link org.appops.scheduler.service.JobPipelineProcessorImpl}.
   *
   * @param jobPipelineQueue job pipeline queue.
   * @param jobStageConverter A converter which converts the {@link org.appops.job.JobStage} into
   *        {@link org.appops.core.job.token.JobToken}.
   * @param jobTokenQueue queue of {@link org.appops.core.job.token.JobToken}
   */
  @Inject
  public JobPipelineProcessorImpl(Provider<JobPipelineQueue> jobPipelineQueue,
      Provider<JobStageConverter> jobStageConverter, Provider<JobTokenQueue> jobTokenQueue) {
    this.jobPipelineQueue = jobPipelineQueue;
    this.jobStageConverter = jobStageConverter;
    this.jobTokenQueue = jobTokenQueue;
  }

  @Override
  public void processJobPipeline() {
    JobPipeline jobPipeline = jobPipelineQueue.get().popJobPipeline();

    if (jobPipeline != null && jobPipeline.getJobStageList() != null
        && !jobPipeline.getJobStageList().isEmpty()) {

      JobStage jobStage = jobPipeline.popFirstJobStage();
      jobPipelineQueue.get().addJobStages(jobPipeline.getGuid(), jobPipeline.getJobStageList());
      JobToken jobToken = this.jobStageConverter.get().convertJobStageToJobToken(jobStage);
      jobTokenQueue.get().addToken(jobToken);

    }

  }

}
