/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.scheduler.service;

import com.google.inject.Inject;
import org.appops.core.job.token.JobToken;
import org.appops.core.job.token.TokenType;
import org.appops.core.service.annotation.ServiceOp;
import org.appops.job.JobTokenQueue;
import org.appops.job.TokenScheduler;
import org.appops.scheduler.exception.SchedulerException;
import org.quartz.CronExpression;

/**
 * <p>
 * TokenSchedulerImpl class.
 * </p>
 *
 * @author deba
 * @version $Id: $Id
 */
public class TokenSchedulerImpl implements TokenScheduler {

  private JobTokenQueue tokenQueue;


  /**
   * <p>
   * Constructor for TokenSchedulerImpl.
   * </p>
   *
   * @param queue a {@link org.appops.job.JobTokenQueue} object.
   */
  @Inject
  public TokenSchedulerImpl(JobTokenQueue queue) {
    tokenQueue = queue;
  }
 
  @Override
  public void scheduleToken(JobToken token) {
    validateToken(token);
    tokenQueue.addToken(token);
  }

  /**
   * Validate a token and throw {@link SchedulerException} if token is invalid.
   * 
   * @param token token to be validate
   */
  private void validateToken(JobToken token) {
    if (token == null) {
      throw new SchedulerException("Unabled to add token into queue, Token cannot be null.");
    }
    if (TokenType.SCHEDULE.equals(token.getTokenType())) {
      String scheduleExpression = token.getScheduleExpression();
      if (scheduleExpression == null || !CronExpression.isValidExpression(scheduleExpression)) {
        throw new SchedulerException(
            "Unabled to add token into queue, schedule expression is invalid.");
      }
    }
    if (token.getJobKey() == null || token.getJobKey().isEmpty()) {
      throw new SchedulerException(
          "Unabled to add token into queue, job key cannot be null or empty.");
    }
  }

}
