/*
 * Decompiled with CFR 0.152.
 */
package org.appops.scheduler.app;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.lang.annotation.Annotation;
import org.appops.core.deployment.ServiceConfiguration;
import org.appops.entitystore.core.Schema;
import org.appops.entitystore.hibernate.SchemaDefinitionGenerator;
import org.appops.entitystore.hibernate.SessionFactoryStore;
import org.appops.entitystore.hibernate.configuration.SessionFactoryGenerator;
import org.appops.job.core.Scheduler;
import org.appops.scheduler.queue.JobPipelineQueueImpl;
import org.appops.service.ServiceInitializer;
import org.appops.service.generator.ServiceMetaGenerator;
import org.appops.slim.base.api.ServiceMetaManager;
import org.hibernate.SessionFactory;

@Scheduler
public class SchedulerInitializer
extends ServiceInitializer {
    private Provider<SchemaDefinitionGenerator> schemaDefGenerator;
    private Provider<SessionFactoryGenerator> sessionFactoryGenerator;
    private SessionFactoryStore sessionFactoryStore;
    @Inject
    private JobPipelineQueueImpl jobPipelineQueue;

    @Inject
    public SchedulerInitializer(Provider<ServiceMetaGenerator> serviceMetaGenerator, Provider<ServiceMetaManager> serviceMetaManager) {
        super(serviceMetaGenerator, serviceMetaManager);
    }

    public String initialize(String serviceName, ServiceConfiguration config, Class<? extends Annotation> serviceAnnotation) {
        this.addServiceMeta(serviceName, config, serviceAnnotation);
        this.registerSchemaDefinition(serviceAnnotation);
        this.jobPipelineQueue.addJobPipelinesToQueue();
        return serviceName;
    }

    private void registerSchemaDefinition(Class<? extends Annotation> serviceAnnotation) {
        Schema schema = ((SchemaDefinitionGenerator)this.schemaDefGenerator.get()).generatateSchemaDefinition(serviceAnnotation);
        SessionFactory sessionFactory = ((SessionFactoryGenerator)this.sessionFactoryGenerator.get()).generateSessionFactory(schema);
        this.sessionFactoryStore.addSessionFactory(schema.getName(), sessionFactory);
    }

    public Provider<SchemaDefinitionGenerator> getSchemaDefGenerator() {
        return this.schemaDefGenerator;
    }

    public Provider<SessionFactoryGenerator> getSessionFactoryGenerator() {
        return this.sessionFactoryGenerator;
    }

    public SessionFactoryStore getSessionFactoryStore() {
        return this.sessionFactoryStore;
    }

    @Inject
    public void setSchemaDefGenerator(Provider<SchemaDefinitionGenerator> schemaDefGenerator) {
        this.schemaDefGenerator = schemaDefGenerator;
    }

    @Inject
    public void setSessionFactoryGenerator(Provider<SessionFactoryGenerator> sessionFactoryGenerator) {
        this.sessionFactoryGenerator = sessionFactoryGenerator;
    }

    @Inject
    public void setSessionFactoryStore(SessionFactoryStore sessionFactoryStore) {
        this.sessionFactoryStore = sessionFactoryStore;
    }
}

