/*
 * Decompiled with CFR 0.152.
 */
package org.appops.scheduler.helper;

import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.appops.job.JobPipeline;
import org.appops.marshaller.DescriptorType;
import org.appops.marshaller.Marshaller;
import org.appops.scheduler.converter.JobPipelineConverter;
import org.appops.scheduler.dao.JobPipelineDao;
import org.appops.scheduler.pojo.JobPipelinePojo;
import org.hibernate.Hibernate;
import org.hibernate.Session;

public class JobPipelineHelper {
    private JobPipelineDao jobPipelineDao;
    private Logger logger = Logger.getLogger(this.getClass().getSimpleName());
    private JobPipelineConverter jobPipelineConverter;
    @Inject
    private Marshaller marshaller;

    @Inject
    public JobPipelineHelper(JobPipelineDao jobPipelineDao) {
        this.jobPipelineDao = jobPipelineDao;
    }

    public JobPipeline saveJobPipeline(JobPipeline jobPipeline) {
        this.jobPipelineConverter = new JobPipelineConverter();
        JobPipelinePojo jobPipelinePojo = new JobPipelinePojo();
        jobPipelinePojo = this.jobPipelineConverter.convertJobPipelineToPojo(jobPipeline);
        jobPipelinePojo.setSchedularExpression(jobPipeline.getScheduleExpression());
        jobPipelinePojo.setJobInfo(this.getBlob(jobPipeline));
        jobPipelinePojo.setCreatedOn(new Date().toString());
        Integer id = (Integer)this.jobPipelineDao.savePojo(jobPipelinePojo);
        if (id != 0) {
            return jobPipeline;
        }
        return null;
    }

    private Blob getBlob(JobPipeline jobPipeline) {
        Blob data = null;
        String jobPipelineJson = null;
        try {
            jobPipelineJson = this.marshaller.marshall((Object)jobPipeline, DescriptorType.JSON);
            data = Hibernate.getLobCreator((Session)this.jobPipelineDao.getPojoSession()).createBlob(IOUtils.toByteArray((String)jobPipelineJson));
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "error while converting into blob", e);
        }
        return data;
    }

    public List<JobPipeline> getExistingJobPipelines(String scheduleAt) throws SQLException {
        ArrayList<JobPipeline> jobPipelinelist = new ArrayList<JobPipeline>();
        List<JobPipelinePojo> jobPipelinePojolist = this.jobPipelineDao.getExistingJobPipelines(scheduleAt);
        for (JobPipelinePojo pojo : jobPipelinePojolist) {
            JobPipeline jobPipeline = this.getExistingJobPipelinesFromBlob(pojo.getJobInfo());
            jobPipelinelist.add(jobPipeline);
        }
        return jobPipelinelist;
    }

    private JobPipeline getExistingJobPipelinesFromBlob(Blob jobInfo) throws SQLException {
        String pipelineJson = this.convertBlobTojson(jobInfo);
        JobPipeline jobPipeline = (JobPipeline)this.marshaller.unmarshall(pipelineJson, JobPipeline.class, DescriptorType.JSON);
        return jobPipeline;
    }

    private String convertBlobTojson(Blob jobInfo) throws SQLException {
        if (jobInfo == null) {
            return null;
        }
        InputStream is = null;
        try {
            String str;
            is = jobInfo.getBinaryStream();
            if (is == null) {
                String string = null;
                return string;
            }
            byte[] data = new byte[(int)jobInfo.length()];
            if (data.length == 0) {
                String e = null;
                return e;
            }
            is.read(data);
            String string = str = new String(data);
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public List<JobPipeline> getAllJobPipelines() {
        ArrayList<JobPipeline> jobPipelinelist = new ArrayList<JobPipeline>();
        List<JobPipelinePojo> jobPipelinePojolist = this.jobPipelineDao.getAllJobPipelines();
        for (JobPipelinePojo pojo : jobPipelinePojolist) {
            JobPipeline jobPipeline = null;
            try {
                jobPipeline = this.getExistingJobPipelinesFromBlob(pojo.getJobInfo());
                jobPipeline.setScheduleExpression(pojo.getSchedularExpression());
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            jobPipelinelist.add(jobPipeline);
        }
        return jobPipelinelist;
    }
}

