/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.scheduler.service;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Set;
import org.appops.core.job.token.JobToken;
import org.appops.core.job.token.JobTokenSet;
import org.appops.core.service.annotation.ServiceOp;
import org.appops.job.JobTokenQueue;
import org.appops.job.TokenProcessor;
import org.appops.service.job.TokenRouter;

/**
 * <p>
 * TokenProcessorImpl class.
 * </p>
 *
 * @author deba
 * @version $Id: $Id
 */
public class TokenProcessorImpl implements TokenProcessor {

  private JobTokenQueue tokenQueue;
  private Provider<TokenRouter> tokenRouter;


  /**
   * <p>
   * Constructor for TokenProcessorImpl.
   * </p>
   *
   * @param queue a {@link org.appops.job.JobTokenQueue} object.
   * @param tokenRouter a {@link com.google.inject.Provider} object.
   */
  @Inject
  public TokenProcessorImpl(JobTokenQueue queue, Provider<TokenRouter> tokenRouter) {
    tokenQueue = queue;
    this.tokenRouter = tokenRouter;
  }
  
  @Override
  public void processTokens() {
    // TODO: Add exception handling.
    Set<JobToken> tokens = tokenQueue.popTokens();
    JobTokenSet jobTokenSet = new JobTokenSet();
    jobTokenSet.addAll(tokens);
    tokenRouter.get().routeJobTokens(jobTokenSet);
  }
}
