/*
 * Decompiled with CFR 0.152.
 */
package org.appops.scheduler.service;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.appops.core.job.token.JobToken;
import org.appops.job.JobPipeline;
import org.appops.job.JobPipelineProcessor;
import org.appops.job.JobPipelineQueue;
import org.appops.job.JobStage;
import org.appops.job.JobStageConverter;
import org.appops.job.JobTokenQueue;

public class JobPipelineProcessorImpl
implements JobPipelineProcessor {
    private Provider<JobPipelineQueue> jobPipelineQueue;
    private Provider<JobStageConverter> jobStageConverter;
    private Provider<JobTokenQueue> jobTokenQueue;

    @Inject
    public JobPipelineProcessorImpl(Provider<JobPipelineQueue> jobPipelineQueue, Provider<JobStageConverter> jobStageConverter, Provider<JobTokenQueue> jobTokenQueue) {
        this.jobPipelineQueue = jobPipelineQueue;
        this.jobStageConverter = jobStageConverter;
        this.jobTokenQueue = jobTokenQueue;
    }

    public void processJobPipeline() {
        JobPipeline jobPipeline = ((JobPipelineQueue)this.jobPipelineQueue.get()).popJobPipeline();
        if (jobPipeline != null && jobPipeline.getJobStageList() != null && !jobPipeline.getJobStageList().isEmpty()) {
            JobStage jobStage = jobPipeline.popFirstJobStage();
            ((JobPipelineQueue)this.jobPipelineQueue.get()).addJobStages(jobPipeline.getGuid(), jobPipeline.getJobStageList());
            JobToken jobToken = ((JobStageConverter)this.jobStageConverter.get()).convertJobStageToJobToken(jobStage);
            ((JobTokenQueue)this.jobTokenQueue.get()).addToken(jobToken);
        }
    }
}

