/*
 * Decompiled with CFR 0.152.
 */
package org.appops.scheduler.thread;

import com.google.inject.Inject;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.appops.core.annotation.Config;
import org.appops.job.JobPipelineProcessor;
import org.appops.job.JobSchedulerThread;
import org.appops.job.TokenProcessor;
import org.appops.scheduler.config.SchedulerConfig;

public class JobSchedulerThreadImpl
implements JobSchedulerThread {
    private TokenProcessor tokenProcessor;
    private JobPipelineProcessor jobPipelineProcessor;
    private Logger logger = Logger.getLogger(this.getClass().getCanonicalName());
    private Timer timer;
    private long period;

    @Inject
    public JobSchedulerThreadImpl(TokenProcessor tokenProcessor, JobPipelineProcessor jobPipelineProcessor) {
        this.tokenProcessor = tokenProcessor;
        this.jobPipelineProcessor = jobPipelineProcessor;
    }

    @Inject
    public void initSchedulerConfig(@Config SchedulerConfig schedulerConfig) {
        this.period = schedulerConfig != null && schedulerConfig.getTokenPollPeriodInSec() != null ? (long)(schedulerConfig.getTokenPollPeriodInSec() * 1000) : 1000L;
    }

    public void startJobScheduler() {
        this.timer = new Timer();
        this.timer.schedule(this.createTimerTask(), 0L, this.period);
    }

    private TimerTask createTimerTask() {
        return new TimerTask(){

            @Override
            public void run() {
                try {
                    JobSchedulerThreadImpl.this.jobPipelineProcessor.processJobPipeline();
                    JobSchedulerThreadImpl.this.tokenProcessor.processTokens();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
    }

    public void stop() {
        if (this.timer != null) {
            this.timer.cancel();
            this.logger.log(Level.INFO, "Timer is terminated,It Does not interfere with a\n   * currently executing task (if it exists)");
        }
    }
}

