/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.job;

import java.util.LinkedList;
import org.appops.core.service.RequestMethod;
import org.appops.core.service.annotation.ServiceOp;
import org.appops.job.core.Scheduler;

/**
 * An interface which provides Job pipeline related functionality.
 *
 * @author suraj
 * @version $Id: $Id
 */
@Scheduler
public interface JobPipelineQueue {

  /**
   * Adds {@link org.appops.job.JobPipeline}to the Job pipeline queue.
   *
   * @param jobPipeline added into Job pipeline queue
   */
  @ServiceOp(path = "addJobPipeline", method = RequestMethod.POST)
  public void addJobPipeline(JobPipeline jobPipeline);

  /**
   * Fetches current size of token queue.
   *
   * @return Number of job pipelines present in job pipeline queue.
   */
  @ServiceOp(path = "size", method = RequestMethod.GET)
  public Integer size();

  /**
   * Fetches next Job pipeline from queue for execution.
   *
   * @return Job pipeline from Job pipeline queue
   */
  @ServiceOp(path = "popJobPipeline", method = RequestMethod.GET)
  public JobPipeline popJobPipeline();

  /**
   * Adds the list of {@link org.appops.job.JobStage} against given job pipeline key.
   *
   * @param jobPipelineKey job pipeline guid
   * @param jobStage list of {@link org.appops.job.JobStage}
   */
  @ServiceOp(path = "addJobStages", method = RequestMethod.POST)
  public void addJobStages(String jobPipelineKey, LinkedList<JobStage> jobStage);

  /**
   * It returns the {@link org.appops.job.JobStage} of given guid.
   *
   * @param guid job pipeline key i.e guid
   * @return {@link org.appops.job.JobStage} of given guid
   */
  @ServiceOp(path = "getNextPipelineJobStage", method = RequestMethod.GET)
  public JobStage getNextPipelineJobStage(String guid);


  /**
   * <p>
   * getJobPipelineFromGuid.
   * </p>
   *
   * @param guid a {@link java.lang.String} object.
   * @return a {@link org.appops.job.JobPipeline} object.
   */
  @ServiceOp(path = "getJobPipelineFromGuid", method = RequestMethod.GET)
  public JobPipeline getJobPipelineFromGuid(String guid);

}
