/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.job;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.appops.core.job.token.JobToken;
import org.appops.core.service.RequestMethod;
import org.appops.core.service.annotation.ServiceOp;
import org.appops.job.core.Scheduler;

/**
 * A queue that maintains tokens of jobs which are submitted for execution.
 *
 * @author deba
 * @version $Id: $Id
 */
@Scheduler
public interface JobTokenQueue {


  /**
   * Adds job token to the queue.
   *
   * @param retrialJobToken Token to be added.
   */
  @ServiceOp(path = "addToken", method = RequestMethod.POST)
  public void addToken(org.appops.core.job.token.JobToken retrialJobToken);


  /**
   * Checks if token is present in queue or not.
   *
   * @param token Token to be checked.
   * @return Boolean flag, true if token is present in queue.
   */
  @ServiceOp(path = "isTokenPresent", method = RequestMethod.GET)
  public Boolean isTokenPresent(JobToken token);

  /**
   * Removes list of tokens from queue.
   *
   * @param ids Tokens to be removed from queue.
   * @return boolean flag, true if tokens removed from queue.
   */
  @ServiceOp(path = "removeJobTokens", method = RequestMethod.POST)
  public Boolean removeJobTokens(List<JobToken> ids);

  /**
   * Fetches all scheduled tokens from queue.
   *
   * @return map containing all schedule tokens fetched from queue.
   */
  @ServiceOp(path = "getScheduleTokens", method = RequestMethod.GET)
  public Map<Date, ArrayList<JobToken>> getScheduleTokens();

  /**
   * Fetches current size of token queue.
   *
   * @return Number of tokens present in queue.
   */
  @ServiceOp(path = "size", method = RequestMethod.GET)
  public Integer size();

  /**
   * Fetches next job from queue for execution.
   *
   * @return set of JobToken.
   */
  @ServiceOp(path = "popTokens", method = RequestMethod.POST)
  public Set<JobToken> popTokens();

}
