/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */


package org.appops.job;

import java.util.LinkedList;

/**
 * A {@link org.appops.job.JobStage} list that describes the jobs configuration. It contains list of
 * meta information required for job execution.
 *
 * @author suraj
 * @version $Id: $Id
 */
public class JobPipeline extends JobStage {
  private LinkedList<JobStage> jobStageList;
  private String ioConverterInterfaceName;
  private String ioConverterServiceName;

  /**
   * Default constructor where guid is generated using {@link org.appops.core.GuidGenerator} and set
   * to {@link org.appops.job.JobPipeline}.
   */
  public JobPipeline() {

  }

  /**
   * {@link java.util.LinkedList} of {@link org.appops.job.JobStage}.
   *
   * @return list of job stages.
   */
  public LinkedList<JobStage> getJobStageList() {
    if (jobStageList == null) {
      jobStageList = new LinkedList<JobStage>();
    }
    return jobStageList;
  }

  /**
   * <p>
   * Setter for the field <code>jobStageList</code>.
   * </p>
   *
   * @param jobStageList a {@link java.util.LinkedList} object.
   */
  public void setJobStageList(LinkedList<JobStage> jobStageList) {
    this.jobStageList = jobStageList;
  }

  /**
   * Add Job stage into job pipeline.
   *
   * @param jobStage job stage to be add into job pipeline.
   * @return true if added successfully otherwise false.
   */
  public boolean jobEntry(JobStage jobStage) {
    jobStage.setGuid(this.getGuid());
    return getJobStageList().add(jobStage);
  }

  /**
   * It returns the first {@link org.appops.job.JobStage} from JobPipeline.
   *
   * @return first {@link org.appops.job.JobStage} from JobPipeline.
   */
  public JobStage popFirstJobStage() {
    if (this.jobStageList != null && !this.jobStageList.isEmpty()) {
      JobStage jobStage = this.jobStageList.get(0);
      jobStageList.remove(jobStage);
      return jobStage;
    }
    return null;
  }

  /**
   * <p>
   * Getter for the field <code>ioConverterInterfaceName</code>.
   * </p>
   *
   * @return a {@link java.lang.String} object.
   */
  public String getIoConverterInterfaceName() {
    return ioConverterInterfaceName;
  }

  /**
   * <p>
   * Setter for the field <code>ioConverterInterfaceName</code>.
   * </p>
   *
   * @param ioConverterInterfaceName a {@link java.lang.String} object.
   */
  public void setIoConverterInterfaceName(String ioConverterInterfaceName) {
    this.ioConverterInterfaceName = ioConverterInterfaceName;
  }

  /**
   * <p>
   * Getter for the field <code>ioConverterServiceName</code>.
   * </p>
   *
   * @return a {@link java.lang.String} object.
   */
  public String getIoConverterServiceName() {
    return ioConverterServiceName;
  }

  /**
   * <p>
   * Setter for the field <code>ioConverterServiceName</code>.
   * </p>
   *
   * @param ioConverterServiceName a {@link java.lang.String} object.
   */
  public void setIoConverterServiceName(String ioConverterServiceName) {
    this.ioConverterServiceName = ioConverterServiceName;
  }

}
