/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.job;

import org.appops.core.job.token.JobToken;
import org.appops.core.service.RequestMethod;
import org.appops.core.service.annotation.ServiceOp;
import org.appops.job.core.Scheduler;

/**
 * A converter which converts the {@link org.appops.job.JobStage} into
 * {@link org.appops.core.job.token.JobToken}.
 *
 * @author suraj
 * @version $Id: $Id
 */
@Scheduler
public interface JobStageConverter {

  /**
   * Converts {@link org.appops.job.JobStage} to {@link org.appops.core.job.token.JobToken}.
   *
   * @param jobStage stage of the job.
   * @return {@link org.appops.core.job.token.JobToken}
   */
  @ServiceOp(path = "convertJobStageToJobToken", method = RequestMethod.POST)
  public JobToken convertJobStageToJobToken(JobStage jobStage);
}
