/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.service.client;

/**
 * represents the Web Client Response.
 *
 * @author vinay@ainosoft.com.
 * @version $Id: $Id
 */
public class WebClientResponse {

  private Object responseObject;
  private String redirectUrl;

  /**
   * init method.
   */
  public WebClientResponse() {

  }

  /**
   * init method.
   *
   * @param responseObject is actual response object.
   * @param redirectUrl is the redirect url.
   */
  public WebClientResponse(Object responseObject, String redirectUrl) {
    this.responseObject = responseObject;
    this.setRedirectUrl(redirectUrl);
  }



  /**
   * <p>
   * Getter for the field <code>responseObject</code>.
   * </p>
   *
   * @return a {@link java.lang.Object} object.
   */
  public Object getResponseObject() {
    return responseObject;
  }

  /**
   * <p>
   * Setter for the field <code>responseObject</code>.
   * </p>
   *
   * @param responseObject a {@link java.lang.Object} object.
   */
  public void setResponseObject(Object responseObject) {
    this.responseObject = responseObject;
  }

  /**
   * <p>
   * Getter for the field <code>redirectUrl</code>.
   * </p>
   *
   * @return a {@link java.lang.String} object.
   */
  public String getRedirectUrl() {
    return redirectUrl;
  }

  /**
   * <p>
   * Setter for the field <code>redirectUrl</code>.
   * </p>
   *
   * @param redirectUrl a {@link java.lang.String} object.
   */
  public void setRedirectUrl(String redirectUrl) {
    this.redirectUrl = redirectUrl;
  }

}
